/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.generator.generator;

import java.util.ArrayList;
import java.util.List;

public class NameFixer {
    private static List<Fix> CLASSNAME_FIXES = new ArrayList<Fix>();

    private static void simpleFix(String s) {
        CLASSNAME_FIXES.add(new SimpleFix(s));
    }

    private static void customFix(String s, String r) {
        CLASSNAME_FIXES.add(new CustomFix(s, r));
    }

    public static String fixClassName(String input) {
        for (Fix s : CLASSNAME_FIXES) {
            input = s.fix(input);
        }
        return input;
    }

    static {
        NameFixer.customFix("Activemq", "ActiveMQ");
        NameFixer.simpleFix("Acl");
        NameFixer.simpleFix("Ajp");
        NameFixer.simpleFix("Ee");
        NameFixer.simpleFix("Ejb");
        NameFixer.simpleFix("Ha");
        NameFixer.simpleFix("Http");
        NameFixer.simpleFix("Io");
        NameFixer.simpleFix("Iiop");
        NameFixer.simpleFix("Imap");
        NameFixer.customFix("InVm", "InVM");
        NameFixer.simpleFix("Jaxrs");
        NameFixer.simpleFix("Jca");
        NameFixer.simpleFix("Jdbc");
        NameFixer.customFix("Jgroups", "JGroups");
        NameFixer.simpleFix("Jms");
        NameFixer.simpleFix("Jmx");
        NameFixer.simpleFix("Jpa");
        NameFixer.simpleFix("Jsf");
        NameFixer.simpleFix("Jsp");
        NameFixer.simpleFix("Jsse");
        NameFixer.simpleFix("Mdb");
        NameFixer.simpleFix("Msc");
        NameFixer.simpleFix("Pop3");
        NameFixer.simpleFix("Sasl");
        NameFixer.simpleFix("Smtp");
        NameFixer.simpleFix("Xa");
    }

    public static class CustomFix
    implements Fix {
        private final String key;
        private final String replacement;

        public CustomFix(String key, String replacement) {
            this.key = key;
            this.replacement = replacement;
        }

        @Override
        public String fix(String input) {
            return input.replace(this.key, this.replacement);
        }
    }

    public static class SimpleFix
    implements Fix {
        private final String key;

        public SimpleFix(String key) {
            this.key = key;
        }

        @Override
        public String fix(String input) {
            StringBuffer output = new StringBuffer();
            int cur = 0;
            while (cur < input.length()) {
                int loc = input.indexOf(this.key, cur);
                if (loc < 0) {
                    output.append(input.substring(cur));
                    break;
                }
                output.append(input.substring(cur, loc));
                int nextCharLoc = loc + this.key.length();
                if (nextCharLoc >= input.length() || nextCharLoc < input.length() && Character.isUpperCase(input.charAt(nextCharLoc))) {
                    output.append(this.key.toUpperCase());
                } else {
                    output.append(this.key);
                }
                cur = loc + this.key.length();
            }
            return output.toString();
        }
    }

    public static interface Fix {
        public String fix(String var1);
    }
}

