/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.generator.generator;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.logmanager.Level;
import org.wildfly.swarm.config.generator.generator.ClassPlan;
import org.wildfly.swarm.config.generator.generator.ClientFactory;
import org.wildfly.swarm.config.generator.generator.Config;
import org.wildfly.swarm.config.generator.generator.ConfiguratorInterfaceFactory;
import org.wildfly.swarm.config.generator.generator.GeneratorTarget;
import org.wildfly.swarm.config.generator.generator.ResourceClassFactory;
import org.wildfly.swarm.config.generator.generator.ResourceMetaData;
import org.wildfly.swarm.config.generator.generator.SubsystemPlan;
import org.wildfly.swarm.config.generator.model.DefaultStatementContext;
import org.wildfly.swarm.config.generator.model.ResourceDescription;
import org.wildfly.swarm.config.generator.operations.ReadDescription;
import org.wildfly.swarm.config.runtime.model.AddressTemplate;
import org.wildfly.swarm.config.runtime.model.StatementContext;

public class Generator {
    private static final Logger log = Logger.getLogger(Generator.class.getName());
    private static ModelControllerClient client;
    private DefaultStatementContext statementContext = new DefaultStatementContext();
    private final String targetDir;
    private final Config config;

    public Generator(String targetDir, Config config) {
        this.targetDir = targetDir;
        this.config = config;
        try {
            client = ClientFactory.createClient(config);
        }
        catch (Exception e) {
            log.log((java.util.logging.Level)Level.ERROR, "Failed to create model controller client", e);
        }
    }

    public static void main(String[] args) throws Exception {
        log.info("Config: " + args[0]);
        log.info("Output: " + args[1]);
        try {
            Config config = Config.fromJson(args[0]);
            Generator generator = new Generator(args[1], config);
            generator.processGeneratorTargets();
            generator.shutdown();
        }
        catch (Throwable e) {
            System.exit(-1);
            log.log((java.util.logging.Level)Level.ERROR, "Unexpected error", e);
        }
    }

    public void deleteDir(String dir) throws Exception {
        Path directory = Paths.get(dir, new String[0]);
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public void shutdown() {
        try {
            client.close();
        }
        catch (IOException e) {
            log.log((java.util.logging.Level)Level.ERROR, e.getMessage());
        }
    }

    public void processGeneratorTargets() {
        if (Files.exists(Paths.get(this.targetDir, new String[0]), new LinkOption[0])) {
            System.out.println("Delete output dir: " + this.targetDir);
            try {
                this.deleteDir(this.targetDir);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        ArrayList subsystems = new ArrayList();
        this.config.getGeneratorTargets().forEach(target -> {
            try {
                ResourceMetaData resourceMetaData = this.loadResourceMetaData((GeneratorTarget)target);
                resourceMetaData.set(ResourceMetaData.PKG, target.getTargetPackage());
                SubsystemPlan plan = new SubsystemPlan(resourceMetaData);
                subsystems.add(plan);
                List<ClassPlan> classPlans = plan.getClassPlans();
                for (ClassPlan classPlan : classPlans) {
                    ResourceClassFactory.createResourceAsClass(plan, classPlan);
                    ConfiguratorInterfaceFactory.createConfiguratorAsInterface(plan, classPlan);
                }
                for (ClassPlan classPlan : classPlans) {
                    if (classPlan.getResourceClassSource() == null) {
                        System.err.println("did not generate: " + classPlan.getFullyQualifiedClassName());
                    } else {
                        this.write((JavaType)classPlan.getResourceClassSource());
                        System.err.println("wrote: " + classPlan.getFullyQualifiedClassName());
                    }
                    if (classPlan.getConfiguratorInterfaceSource() == null) {
                        System.err.println("did not generate: " + classPlan.getFullyQualifiedClassName() + "Configurator");
                        continue;
                    }
                    this.write((JavaType)classPlan.getConfiguratorInterfaceSource());
                    System.err.println("wrote: " + classPlan.getFullyQualifiedClassName() + "Configurator");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.log((java.util.logging.Level)Level.ERROR, "Failed to process targets", e);
            }
        });
        System.err.println("----------------- BEGIN module.xml paths -----------------------");
        subsystems.stream().flatMap(e -> e.getClassPlans().stream()).map(e -> e.getPackageName()).collect(Collectors.toSet()).stream().sorted().forEach(e -> System.err.println("        <path name=\"" + e.replace('.', '/') + "\"/>"));
        System.err.println("----------------- END module.xml paths -------------------------");
    }

    private void write(JavaType javaClass) {
        try {
            String dir = this.targetDir + File.separator + javaClass.getPackage().replace(".", File.separator);
            Files.createDirectories(Paths.get(dir, new String[0]), new FileAttribute[0]);
            Path fileName = Paths.get(dir + File.separator + javaClass.getName() + ".java", new String[0]);
            if (Files.exists(fileName, new LinkOption[0])) {
                System.err.println("File already exists, will be replaced: " + fileName);
            }
            Files.write(fileName, javaClass.toString().getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            log.log((java.util.logging.Level)Level.ERROR, "Failed to persist class", e);
        }
    }

    private ResourceMetaData loadResourceMetaData(GeneratorTarget generatorTarget) throws Exception {
        AddressTemplate address = generatorTarget.getSourceAddress();
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        ArrayList<ModelNode> steps = new ArrayList<ModelNode>();
        Integer tokens = address.tokenLength();
        AddressTemplate parentAddress = address.subTemplate(0, tokens - 1);
        ModelNode childTypes = new ModelNode();
        childTypes.get("operation").set("read-children-types");
        childTypes.get("address").set((ModelNode)parentAddress.resolve((StatementContext)new DefaultStatementContext(), new String[0]));
        childTypes.get("include-singletons").set(true);
        steps.add(childTypes);
        ReadDescription rrd = new ReadDescription(address);
        steps.add(rrd.resolve(this.statementContext));
        composite.get("steps").set(steps);
        ModelNode response = client.execute(composite);
        boolean isSingleton = false;
        List types = response.get("result").get("step-1").get("result").asList();
        for (ModelNode type : types) {
            if (!type.asString().equals(address.getResourceType() + "=" + address.getResourceName())) continue;
            isSingleton = true;
            break;
        }
        ResourceDescription description = ResourceDescription.from(response.get("result").get("step-2"));
        if (isSingleton) {
            description.setSingletonName(address.getResourceName());
        }
        return new ResourceMetaData(generatorTarget.getSourceAddress(), description);
    }
}

