/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.generator.model;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class ResourceDescription
extends ModelNode {
    public static final ResourceDescription EMPTY = new ResourceDescription();
    static final String ACCESS_CONTROL = "access-control";
    static final String NOTIFICATIONS = "notifications";
    private boolean isSingleton;
    private String singletonName;

    public ResourceDescription() {
    }

    public ResourceDescription(ModelNode description) {
        this.set(description);
    }

    public boolean hasAttributes() {
        return this.hasDefined("attributes");
    }

    public List<Property> getAttributes() {
        return this.hasAttributes() ? this.get("attributes").asPropertyList() : Collections.EMPTY_LIST;
    }

    public boolean hasAccessControl() {
        return this.hasDefined(ACCESS_CONTROL);
    }

    public boolean hasChildrenDefined() {
        return this.hasDefined("children") && !this.get("children").keys().isEmpty();
    }

    public boolean hasOperations() {
        return this.hasDefined("operations");
    }

    public boolean hasNotifications() {
        return this.hasDefined(NOTIFICATIONS);
    }

    public Set<String> getChildrenTypes() {
        HashSet<String> result = new HashSet<String>();
        if (this.hasChildrenDefined()) {
            ModelNode children = this.get("children");
            List items = children.asPropertyList();
            for (Property item : items) {
                Set keys = item.getValue().get("model-description").keys();
                if (!keys.contains("*")) continue;
                result.add(item.getName());
            }
        }
        return result;
    }

    public Set<String> getSingletonChildrenTypes() {
        HashSet<String> result = new HashSet<String>();
        if (this.hasChildrenDefined()) {
            ModelNode children = this.get("children");
            List items = children.asPropertyList();
            for (Property item : items) {
                Set keys = item.getValue().get("model-description").keys();
                if (keys.contains("*")) continue;
                result.addAll(keys.stream().map(key -> item.getName() + "=" + key).collect(Collectors.toList()));
            }
        }
        return result;
    }

    public ResourceDescription getChildDescription(String childType) {
        return this.getChildDescription(childType, "*");
    }

    public ResourceDescription getChildDescription(String type, String name) {
        if (this.hasChildrenDefined()) {
            List children = this.get("children").asPropertyList();
            for (Property child : children) {
                if (!type.equals(child.getName()) || !child.getValue().hasDefined("model-description")) continue;
                List modelDescriptions = child.getValue().get("model-description").asPropertyList();
                for (Property modelDescription : modelDescriptions) {
                    if (!name.equals(modelDescription.getName())) continue;
                    return new ResourceDescription(modelDescription.getValue());
                }
            }
        }
        return EMPTY;
    }

    public static ResourceDescription from(ModelNode response) {
        if (!response.get("outcome").asString().equals("success")) {
            throw new RuntimeException(response.get("failure-description").asString());
        }
        ModelNode result = response.get("result");
        if (ModelType.LIST == result.getType()) {
            return new ResourceDescription(((ModelNode)result.asList().get(0)).get("result"));
        }
        return new ResourceDescription(result);
    }

    public String getText() {
        return this.get("description").asString();
    }

    public boolean isSingleton() {
        return this.isSingleton;
    }

    public String getSingletonName() {
        return this.singletonName;
    }

    public void setSingletonName(String name) {
        this.isSingleton = true;
        this.singletonName = name;
    }
}

