/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.generator.generator;

import java.util.logging.Logger;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.source.JavaInterfaceSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.wildfly.swarm.config.generator.generator.ClassIndex;
import org.wildfly.swarm.config.generator.generator.ClassPlan;
import org.wildfly.swarm.config.generator.generator.SourceFactory;

public class ConsumerFactory
implements SourceFactory {
    private static final Logger log = Logger.getLogger(ConsumerFactory.class.getName());

    @Override
    public JavaType create(ClassIndex index, ClassPlan plan) {
        JavaInterfaceSource type = (JavaInterfaceSource)Roaster.parse(JavaInterfaceSource.class, (String)("public interface " + plan.getClassName() + "Consumer<T extends " + plan.getClassName() + "<T>> {}"));
        type.setPackage(plan.getPackageName());
        type.addImport(plan.getPackageName() + "." + plan.getClassName());
        type.addAnnotation(FunctionalInterface.class);
        this.addAccept(type, plan);
        this.addAndThen(type, plan);
        return type;
    }

    protected void addAccept(JavaInterfaceSource type, ClassPlan plan) {
        MethodSource method = type.addMethod();
        method.getJavaDoc().setText("Configure a pre-constructed instance of " + plan.getClassName() + " resource").addTagValue("@parameter", "Instance of " + plan.getClassName() + " to configure").addTagValue("@return", "nothing");
        method.addParameter("T", "value");
        ((MethodSource)method.setName("accept")).setReturnType("void");
    }

    protected void addAndThen(JavaInterfaceSource type, ClassPlan plan) {
        type.addMethod("default " + plan.getClassName() + "Consumer<T> andThen(" + plan.getClassName() + "Consumer<T> after) {\n" + "  return (c)->{ this.accept(c); after.accept(c);};\n" + "}\n");
    }
}

