/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.generator.generator;

import java.util.HashMap;
import java.util.Map;
import org.wildfly.swarm.config.generator.model.ResourceDescription;
import org.wildfly.swarm.config.runtime.model.AddressTemplate;

public class ResourceMetaData
implements Comparable<ResourceMetaData> {
    public static String PKG = "package";
    private AddressTemplate address;
    private ResourceDescription desc;
    private Map<String, String> cfg = new HashMap<String, String>();

    public ResourceMetaData(AddressTemplate address, ResourceDescription desc) {
        if (!desc.isDefined()) {
            throw new IllegalStateException("Undefined resource description");
        }
        this.address = address;
        this.desc = desc;
    }

    public AddressTemplate getAddress() {
        return this.address;
    }

    public ResourceDescription getDescription() {
        return this.desc;
    }

    @Override
    public int compareTo(ResourceMetaData o) {
        return this.address.compareTo(o.address);
    }

    public String get(String key) {
        assert (this.cfg.containsKey(key)) : "Configuration missing for key :" + key;
        return this.cfg.get(key);
    }

    public void set(String key, String value) {
        this.cfg.put(key, value);
    }

    public Map<String, String> getAllCfg() {
        return this.cfg;
    }

    public void setAllCfg(Map<String, String> values) {
        this.cfg.putAll(values);
    }

    public String toString() {
        return this.address.getTemplate();
    }
}

