/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.generator.generator;

import com.google.common.base.CaseFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaInterfaceSource;
import org.wildfly.swarm.config.generator.generator.ResourceMetaData;
import org.wildfly.swarm.config.generator.model.ResourceDescription;
import org.wildfly.swarm.config.runtime.model.AddressTemplate;

public class ClassPlan
implements Comparable<ClassPlan> {
    private final List<ResourceMetaData> meta = new ArrayList<ResourceMetaData>();
    private final String type;
    private String packageName;
    private String className;
    private String addresses;
    private JavaClassSource resourceSource;
    private JavaInterfaceSource configSource;
    private boolean templated = false;

    ClassPlan(ResourceMetaData meta) {
        this(Collections.singletonList(meta));
    }

    ClassPlan(List<ResourceMetaData> meta) {
        this.meta.addAll(meta);
        this.packageName = this.determinePackageName(0);
        this.className = this.determineClassName(0);
        AddressTemplate addr = this.meta.get(0).getAddress();
        this.type = addr.subTemplate(addr.tokenLength() - 1, addr.tokenLength().intValue()).getResourceType();
    }

    String getResourceType() {
        return this.type;
    }

    void setTemplated(boolean templated) {
        this.templated = templated;
    }

    boolean isTemplated() {
        return this.templated;
    }

    String getThisReturnType() {
        if (this.templated) {
            return "T";
        }
        return this.className;
    }

    boolean isSingleton() {
        return this.meta.get(0).getDescription().isSingleton();
    }

    String getSingletonName() {
        return this.meta.get(0).getDescription().getSingletonName();
    }

    ResourceDescription getDescription() {
        return this.meta.get(0).getDescription();
    }

    ResourceMetaData getMetaData() {
        return this.meta.get(0);
    }

    void setResourceClassSource(JavaClassSource source) {
        this.resourceSource = source;
    }

    JavaClassSource getResourceClassSource() {
        return this.resourceSource;
    }

    void setConfiguratorInterfaceSource(JavaInterfaceSource source) {
        this.configSource = source;
    }

    JavaInterfaceSource getConfiguratorInterfaceSource() {
        return this.configSource;
    }

    void deduplicate(int round) {
        this.packageName = this.determinePackageName(round);
    }

    public String toString() {
        return this.getFullyQualifiedClassName();
    }

    String determinePackageName(int uniqueRound) {
        if (this.meta.size() == 1) {
            AddressTemplate address = this.meta.get(0).getAddress();
            int numTokens = address.tokenLength() - 1;
            List<String> segments = this.determineSegments(address, uniqueRound);
            return this.packagize(segments);
        }
        ArrayList<List<String>> allSegments = new ArrayList<List<String>>();
        for (ResourceMetaData resourceMetaData : this.meta) {
            allSegments.add(this.determineSegments(resourceMetaData.getAddress(), uniqueRound));
        }
        ArrayList<String> commonSegments = new ArrayList<String>();
        int i = 0;
        block1: while (true) {
            String cur = null;
            for (List list : allSegments) {
                if (list.size() <= i) break block1;
                if (cur == null) {
                    cur = (String)list.get(i);
                    continue;
                }
                if (cur.equals(list.get(i))) continue;
                break block1;
            }
            commonSegments.add(cur);
            cur = null;
            ++i;
        }
        return this.packagize(commonSegments);
    }

    private List<String> determineSegments(AddressTemplate address, int uniqueRound) {
        int numTokens = address.tokenLength() - 1;
        ArrayList<String> segments = new ArrayList<String>();
        for (int i = 0; i < numTokens; ++i) {
            AddressTemplate part = address.subTemplate(i, i + 1);
            if (i == 0) {
                segments.add(part.getResourceName());
                continue;
            }
            if (i >= numTokens - uniqueRound) {
                segments.add(part.getResourceType());
                segments.add(part.getResourceName());
                continue;
            }
            segments.add(part.getResourceType());
        }
        return segments;
    }

    private String packagize(List<String> segments) {
        if (segments.isEmpty()) {
            return "org.wildfly.swarm.config";
        }
        return "org.wildfly.swarm.config." + String.join((CharSequence)".", segments.stream().map(e -> CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_UNDERSCORE, e)).collect(Collectors.toList()));
    }

    String determineClassName(int uniqueRound) {
        AddressTemplate address = this.meta.get(0).getAddress();
        AddressTemplate last = address.subTemplate(address.tokenLength() - 1, address.tokenLength().intValue());
        String type = last.getResourceType();
        String name = last.getResourceName();
        if (address.tokenLength() == 1 && type.equals("subsystem")) {
            return CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, name);
        }
        if (name.equals("*")) {
            return CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, type);
        }
        if (type.toLowerCase().startsWith(name.toLowerCase())) {
            return CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, type);
        }
        if (name.toLowerCase().endsWith(type.toLowerCase())) {
            return CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, name);
        }
        return CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, name + "-" + type);
    }

    String getPackageName() {
        return this.packageName;
    }

    String getClassName() {
        return this.className;
    }

    String getFullyQualifiedClassName() {
        return this.packageName + "." + this.className;
    }

    @Override
    public int compareTo(ClassPlan o) {
        return this.getFullyQualifiedClassName().compareTo(o.getFullyQualifiedClassName());
    }

    public List<AddressTemplate> getAddresses() {
        return this.meta.stream().map(e -> e.getAddress()).collect(Collectors.toList());
    }
}

