/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.generator.generator;

import com.google.common.base.CaseFormat;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaDocSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.jboss.logmanager.Level;
import org.wildfly.swarm.config.generator.generator.ClassIndex;
import org.wildfly.swarm.config.generator.generator.ClassPlan;
import org.wildfly.swarm.config.generator.generator.Keywords;
import org.wildfly.swarm.config.generator.generator.ResourceMetaData;
import org.wildfly.swarm.config.generator.model.ResourceDescription;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.invocation.Types;
import org.wildfly.swarm.config.runtime.model.AddressTemplate;

public class ResourceClassFactory {
    private static final Logger log = Logger.getLogger(ResourceClassFactory.class.getName());

    public static JavaClassSource createResourceAsClass(ClassIndex index, ClassPlan plan) {
        JavaClassSource javaClass = (JavaClassSource)Roaster.parse(JavaClassSource.class, (String)("public class " + plan.getClassName() + "<T extends " + plan.getClassName() + "> {}"));
        ((FieldSource)((FieldSource)javaClass.addField().setName("key")).setPrivate()).setType(String.class);
        boolean isSingleton = plan.isSingleton();
        if (isSingleton) {
            ((MethodSource)javaClass.addMethod().setConstructor(true).setPublic()).setBody("this.key = \"" + plan.getSingletonName() + "\";");
        } else {
            ((MethodSource)javaClass.addMethod().setConstructor(true).setPublic()).setBody("this.key = key;").addParameter(String.class, "key");
        }
        ((MethodSource)((MethodSource)javaClass.addMethod().setName("getKey")).setPublic()).setReturnType(String.class).setBody("return this.key;");
        javaClass.setPackage(plan.getPackageName());
        JavaDocSource javaDoc = javaClass.getJavaDoc();
        ResourceDescription desc = plan.getDescription();
        javaDoc.setText(desc.getText());
        javaClass.addImport(Implicit.class);
        javaClass.addImport(ResourceType.class);
        javaClass.addImport(ModelNodeBinding.class);
        AnnotationSource typeAnno = javaClass.addAnnotation();
        typeAnno.setName("ResourceType");
        typeAnno.setStringValue(plan.getResourceType());
        if (isSingleton) {
            AnnotationSource implicitMeta = javaClass.addAnnotation();
            implicitMeta.setName("Implicit");
        }
        desc.getAttributes().forEach(att -> {
            ModelType modelType = ModelType.valueOf((String)att.getValue().get("type").asString());
            Optional resolvedType = Types.resolveJavaTypeName((ModelType)modelType, (ModelNode)att.getValue());
            if (resolvedType.isPresent() && !att.getValue().get("deprecated").isDefined()) {
                try {
                    String name = ResourceClassFactory.javaAttributeName(att.getName());
                    String attributeDescription = att.getValue().get("description").asString();
                    ((FieldSource)javaClass.addField().setName(name)).setType((String)resolvedType.get()).setPrivate();
                    MethodSource accessor = javaClass.addMethod();
                    accessor.getJavaDoc().setText(attributeDescription);
                    ((MethodSource)((MethodSource)accessor.setPublic()).setName(name)).setReturnType((String)resolvedType.get()).setBody("return this." + name + ";");
                    MethodSource mutator = javaClass.addMethod();
                    mutator.getJavaDoc().setText(attributeDescription);
                    mutator.addParameter((String)resolvedType.get(), "value");
                    ((MethodSource)((MethodSource)mutator.setPublic()).setName(name)).setReturnType(plan.getThisReturnType()).setBody("this." + name + " = value;\nreturn (" + plan.getThisReturnType() + ") this;").addAnnotation("SuppressWarnings").setStringValue("unchecked");
                    AnnotationSource bindingMeta = accessor.addAnnotation();
                    bindingMeta.setName("ModelNodeBinding");
                    bindingMeta.setStringValue("detypedName", att.getName());
                }
                catch (Exception e) {
                    log.log((java.util.logging.Level)Level.ERROR, "Failed to process " + plan.getFullyQualifiedClassName() + ", attribute " + att.getName(), e);
                }
            }
        });
        if (!desc.getChildrenTypes().isEmpty()) {
            ResourceClassFactory.createChildAccessors(index, plan, javaClass);
        }
        if (!desc.getSingletonChildrenTypes().isEmpty()) {
            ResourceClassFactory.createSingletonChildAccessors(index, plan, javaClass);
        }
        plan.setResourceClassSource(javaClass);
        return javaClass;
    }

    public static void createChildAccessors(ClassIndex index, ClassPlan plan, JavaClassSource javaClass) {
        ResourceMetaData resourceMetaData = plan.getMetaData();
        JavaClassSource subresourceClass = ResourceClassFactory.createSubresourceClass(plan, javaClass);
        ResourceDescription resourceMetaDataDescription = resourceMetaData.getDescription();
        Set<String> childrenNames = resourceMetaDataDescription.getChildrenTypes();
        for (String childName : childrenNames) {
            String propName;
            AddressTemplate childAddress = resourceMetaData.getAddress().append(childName + "=*");
            ClassPlan childClass = index.lookup(childAddress);
            String childClassName = childClass.getFullyQualifiedClassName();
            String propType = "java.util.List<" + childClassName + ">";
            String singularName = propName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, Keywords.escape(childClass.getClassName()));
            if (!propName.endsWith("s")) {
                propName = propName + "s";
            }
            String resourceText = resourceMetaDataDescription.getChildDescription(childName).getText();
            ((FieldSource)((FieldSource)subresourceClass.addField().setName(propName)).setType(propType).setPrivate()).setLiteralInitializer("new java.util.ArrayList<>();").getJavaDoc().setText(resourceText);
            MethodSource accessor = subresourceClass.addMethod();
            accessor.getJavaDoc().setText("Get the list of " + childClassName + " resources").addTagValue("@return", "the list of resources");
            ((MethodSource)((MethodSource)accessor.setPublic()).setName(propName)).setReturnType(propType).setBody("return this." + propName + ";");
            MethodSource listMutator = javaClass.addMethod();
            listMutator.getJavaDoc().setText("Add all " + childClassName + " objects to this subresource").addTagValue("@return", "this").addTagValue("@param", "value List of " + childClassName + " objects.");
            listMutator.addParameter(propType, "value");
            ((MethodSource)((MethodSource)listMutator.setPublic()).setName(propName)).setReturnType(plan.getThisReturnType()).setBody("this.subresources." + propName + ".addAll(value);\nreturn (" + plan.getThisReturnType() + ") this;").addAnnotation("SuppressWarnings").setStringValue("unchecked");
            MethodSource mutator = javaClass.addMethod();
            mutator.getJavaDoc().setText("Add the " + childClassName + " object to the list of subresources").addTagValue("@param", "value The " + childClassName + " to add").addTagValue("@return", "this");
            mutator.addParameter(childClassName, "value");
            ((MethodSource)((MethodSource)mutator.setPublic()).setName(singularName)).setReturnType(plan.getThisReturnType()).setBody("this.subresources." + propName + ".add(value);\nreturn (" + plan.getThisReturnType() + ") this;").addAnnotation("SuppressWarnings").setStringValue("unchecked");
            MethodSource configurator = javaClass.addMethod();
            configurator.getJavaDoc().setText("Create and configure a " + childClassName + " object to the list of subresources").addTagValue("@param", "key The key for the " + childClassName + " resource").addTagValue("@param", "config The " + childClassName + "Configurator to use").addTagValue("@return", "this");
            configurator.addParameter(String.class, "childKey");
            configurator.addParameter(childClassName + "Configurator", "config");
            ((MethodSource)((MethodSource)configurator.setPublic()).setName(singularName)).setReturnType(plan.getThisReturnType()).setBody(childClassName + " child = new " + childClassName + "(childKey);\nconfig.configure(child);\n" + singularName + "(child);\nreturn (" + plan.getThisReturnType() + ") this;").addAnnotation("SuppressWarnings").setStringValue("unchecked");
            AnnotationSource subresourceMeta = accessor.addAnnotation();
            subresourceMeta.setName("Subresource");
        }
        javaClass.addNestedType((JavaSource)subresourceClass);
    }

    private static JavaClassSource createSubresourceClass(ClassPlan plan, JavaClassSource javaClass) {
        JavaClassSource subresourceClass = (JavaClassSource)Roaster.parse(JavaClassSource.class, (String)("class " + javaClass.getName() + "Resources" + " {}"));
        subresourceClass.setPackage(plan.getPackageName());
        subresourceClass.getJavaDoc().setText("Child mutators for " + javaClass.getName());
        subresourceClass.setPublic();
        ((FieldSource)((FieldSource)javaClass.addField().setPrivate()).setType(subresourceClass.getName()).setName("subresources")).setLiteralInitializer("new " + subresourceClass.getName() + "();");
        MethodSource subresourcesMethod = (MethodSource)((MethodSource)javaClass.addMethod().setName("subresources")).setPublic();
        subresourcesMethod.setReturnType(subresourceClass.getName());
        subresourcesMethod.setBody("return this.subresources;");
        javaClass.addImport("java.util.List");
        javaClass.addImport(Subresource.class);
        return subresourceClass;
    }

    public static void createSingletonChildAccessors(ClassIndex index, ClassPlan plan, JavaClassSource javaClass) {
        ResourceMetaData resourceMetaData = plan.getMetaData();
        ResourceDescription description = resourceMetaData.getDescription();
        Set<String> singletonNames = description.getSingletonChildrenTypes();
        javaClass.addImport(Subresource.class);
        for (String singletonName : singletonNames) {
            String[] split = singletonName.split("=");
            String type = split[0];
            String name = split[1];
            AddressTemplate childAddress = resourceMetaData.getAddress().append(type + "=" + name);
            ClassPlan childClass = index.lookup(childAddress);
            String propName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, childClass.getClassName());
            ((FieldSource)javaClass.addField().setName(propName)).setType(childClass.getFullyQualifiedClassName()).setPrivate();
            MethodSource accessor = javaClass.addMethod();
            String javaDoc = description.getChildDescription(type, name).getText();
            accessor.getJavaDoc().setText(javaDoc);
            ((MethodSource)((MethodSource)accessor.setPublic()).setName(propName)).setReturnType(childClass.getFullyQualifiedClassName()).setBody("return this." + propName + ";");
            AnnotationSource subresourceMeta = accessor.addAnnotation();
            subresourceMeta.setName("Subresource");
            MethodSource mutator = javaClass.addMethod();
            mutator.getJavaDoc().setText(javaDoc);
            mutator.addParameter(childClass.getFullyQualifiedClassName(), "value");
            ((MethodSource)((MethodSource)mutator.setPublic()).setName(propName)).setReturnType(plan.getThisReturnType()).setBody("this." + propName + "=value;\nreturn (" + plan.getThisReturnType() + ") this;").addAnnotation("SuppressWarnings").setStringValue("unchecked");
        }
    }

    public static final String javaAttributeName(String dmr) {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, Keywords.escape(dmr.replace("-", "_")));
    }
}

