/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.generator.generator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.wildfly.swarm.config.generator.generator.ClassIndex;
import org.wildfly.swarm.config.generator.generator.ClassPlan;
import org.wildfly.swarm.config.generator.generator.ResourceMetaData;
import org.wildfly.swarm.config.generator.model.ResourceDescription;
import org.wildfly.swarm.config.runtime.model.AddressTemplate;

public class SubsystemPlan
implements ClassIndex {
    private final ResourceMetaData meta;
    private final List<ClassPlan> classPlans = new ArrayList<ClassPlan>();
    private Map<AddressTemplate, ClassPlan> index = new HashMap<AddressTemplate, ClassPlan>();

    SubsystemPlan(ResourceMetaData meta) {
        this.meta = meta;
        this.plan();
    }

    @Override
    public ClassPlan lookup(AddressTemplate address) {
        return this.index.get(address);
    }

    List<ClassPlan> getClassPlans() {
        return this.classPlans;
    }

    /*
     * WARNING - void declaration
     */
    void plan() {
        ClassPlan subsystemClass = new ClassPlan(this.meta);
        subsystemClass.setTemplated(true);
        this.classPlans.add(subsystemClass);
        ArrayList<ResourceMetaData> list = new ArrayList<ResourceMetaData>();
        SubsystemPlan.collect(this.meta, list);
        for (ResourceMetaData resourceMetaData : list) {
            ModelNode attrs = resourceMetaData.getDescription().get("attributes");
            List props = attrs.asPropertyList();
            for (Property prop : props) {
                ModelNode deprecated = prop.getValue().get("deprecated");
                if (!deprecated.isDefined()) continue;
                attrs.remove(prop.getName());
            }
        }
        Map<AddressTemplate, List<ResourceMetaData>> grouped = list.stream().collect(Collectors.groupingBy(e -> {
            AddressTemplate address = e.getAddress();
            return address.subTemplate(address.tokenLength() - 1, address.tokenLength().intValue());
        }));
        for (AddressTemplate key : grouped.keySet()) {
            List<ResourceMetaData> members = grouped.get(key);
            if (members.size() > 1) {
                List<List<ResourceMetaData>> partitions = SubsystemPlan.partition(members);
                for (List<ResourceMetaData> partition : partitions) {
                    this.classPlans.add(new ClassPlan(partition));
                }
                continue;
            }
            this.classPlans.add(new ClassPlan(members));
        }
        Collections.sort(this.classPlans);
        Object var4_6 = null;
        HashSet<ClassPlan> dupes = new HashSet<ClassPlan>();
        for (ClassPlan each : this.classPlans) {
            void var4_7;
            if (var4_7 != null) {
                if (var4_7.getFullyQualifiedClassName().equals(each.getFullyQualifiedClassName())) {
                    dupes.add((ClassPlan)var4_7);
                    dupes.add(each);
                } else if (!dupes.isEmpty()) {
                    SubsystemPlan.deduplicate(dupes);
                    dupes.clear();
                }
            }
            ClassPlan classPlan = each;
        }
        if (!dupes.isEmpty()) {
            SubsystemPlan.deduplicate(dupes);
            dupes.clear();
        }
        for (ClassPlan each : this.classPlans) {
            for (AddressTemplate address : each.getAddresses()) {
                this.index.put(address, each);
            }
        }
    }

    static boolean deduplicate(Set<ClassPlan> dupes) {
        block2: {
            int i = 1;
            do {
                for (ClassPlan dupe : dupes) {
                    dupe.deduplicate(i);
                }
                if (!SubsystemPlan.stillContainsDuplicates(dupes)) break block2;
            } while (++i <= 10);
            return false;
        }
        return true;
    }

    static boolean stillContainsDuplicates(Set<ClassPlan> dupes) {
        HashSet<String> seen = new HashSet<String>();
        for (ClassPlan dupe : dupes) {
            if (seen.contains(dupe.getFullyQualifiedClassName())) {
                return true;
            }
            seen.add(dupe.getFullyQualifiedClassName());
        }
        return false;
    }

    static List<List<ResourceMetaData>> partition(List<ResourceMetaData> list) {
        ArrayList<List<ResourceMetaData>> partitions = new ArrayList<List<ResourceMetaData>>();
        for (ResourceMetaData prime : list) {
            List<ResourceMetaData> matched = SubsystemPlan.findPartition(partitions, prime);
            if (matched == null) {
                matched = new ArrayList<ResourceMetaData>();
                partitions.add(matched);
            }
            matched.add(prime);
        }
        return partitions;
    }

    static List<ResourceMetaData> findPartition(List<List<ResourceMetaData>> partitions, ResourceMetaData prime) {
        for (List<ResourceMetaData> partition : partitions) {
            boolean match;
            if (partition.isEmpty()) continue;
            ResourceMetaData comp = partition.get(0);
            ResourceDescription compDesc = comp.getDescription();
            ResourceDescription primeDesc = prime.getDescription();
            if (compDesc.getAttributes().size() != primeDesc.getAttributes().size() || !(match = compDesc.getAttributes().stream().allMatch(c -> {
                boolean found = primeDesc.getAttributes().stream().anyMatch(p -> {
                    if (!p.getName().equals(c.getName())) {
                        return false;
                    }
                    return p.getValue().getType().equals((Object)c.getValue().getType());
                });
                return found;
            })) || !(match = compDesc.getChildrenTypes().equals(primeDesc.getChildrenTypes())) || !(match = compDesc.getSingletonChildrenTypes().equals(primeDesc.getSingletonChildrenTypes()))) continue;
            return partition;
        }
        return null;
    }

    static void collect(ResourceMetaData root, List<ResourceMetaData> list) {
        Set<String> childTypes = root.getDescription().getChildrenTypes();
        for (String childType : childTypes) {
            ResourceDescription child = root.getDescription().getChildDescription(childType);
            ResourceMetaData childMeta = new ResourceMetaData(root.getAddress().append(childType + "=*"), child);
            list.add(childMeta);
            SubsystemPlan.collect(childMeta, list);
        }
        Set<String> singletonTypes = root.getDescription().getSingletonChildrenTypes();
        for (String childType : singletonTypes) {
            String[] parts = childType.split("=");
            ResourceDescription child = root.getDescription().getChildDescription(parts[0], parts[1]);
            child.setSingletonName(parts[1]);
            ResourceMetaData childMeta = new ResourceMetaData(root.getAddress().append(childType), child);
            list.add(childMeta);
            SubsystemPlan.collect(childMeta, list);
        }
    }
}

