/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.generator.generator;

import java.util.List;
import org.jboss.dmr.ModelNode;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.source.EnumConstantSource;
import org.jboss.forge.roaster.model.source.JavaEnumSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.wildfly.swarm.config.generator.generator.ClassIndex;
import org.wildfly.swarm.config.generator.generator.EnumPlan;

public class EnumFactory {
    public JavaEnumSource create(ClassIndex index, EnumPlan plan) {
        JavaEnumSource enumType = (JavaEnumSource)((JavaEnumSource)((JavaEnumSource)Roaster.create(JavaEnumSource.class)).setName(plan.getClassName())).setPublic();
        if (plan.getPackageName() != null) {
            enumType.setPackage(plan.getPackageName());
        }
        enumType.addProperty(String.class, "allowedValue").getAccessor().getJavaDoc().setText("Returns the allowed value for the management model.").addTagValue("@return", "the allowed model value");
        MethodSource constructor = enumType.addMethod().setConstructor(true);
        constructor.addParameter(String.class, "allowedValue");
        constructor.setBody("this.allowedValue = allowedValue;");
        ((MethodSource)((MethodSource)enumType.addMethod().setName("toString")).setReturnType(String.class).setPublic()).setBody("return allowedValue;").addAnnotation(Override.class);
        List<ModelNode> allowedValues = plan.getAllowedValues();
        allowedValues.forEach(value -> {
            String v = value.asString();
            StringBuilder sb = new StringBuilder();
            block3: for (char c : v.toCharArray()) {
                switch (c) {
                    case '-': 
                    case '.': {
                        sb.append('_');
                        continue block3;
                    }
                    default: {
                        sb.append(Character.toUpperCase(c));
                    }
                }
            }
            EnumConstantSource constantSource = enumType.addEnumConstant(sb.toString());
            constantSource.setConstructorArguments(new String[]{"\"" + value.asString() + "\""});
        });
        return enumType;
    }
}

