/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.generator.generator;

import com.google.common.base.CaseFormat;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaDocSource;
import org.jboss.forge.roaster.model.source.JavaEnumSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.jboss.logmanager.Level;
import org.wildfly.swarm.config.generator.generator.ClassIndex;
import org.wildfly.swarm.config.generator.generator.ClassPlan;
import org.wildfly.swarm.config.generator.generator.EnumFactory;
import org.wildfly.swarm.config.generator.generator.EnumPlan;
import org.wildfly.swarm.config.generator.generator.Inflector;
import org.wildfly.swarm.config.generator.generator.Keywords;
import org.wildfly.swarm.config.generator.generator.ResourceMetaData;
import org.wildfly.swarm.config.generator.generator.SourceFactory;
import org.wildfly.swarm.config.generator.model.ResourceDescription;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.invocation.Types;
import org.wildfly.swarm.config.runtime.model.AddressTemplate;

public class ResourceFactory
implements SourceFactory {
    private static final Logger log = Logger.getLogger(ResourceFactory.class.getName());
    private final Set<String> names = new HashSet<String>();

    public JavaClassSource create(ClassIndex index, ClassPlan plan) {
        this.names.clear();
        JavaClassSource type = (JavaClassSource)Roaster.parse(JavaClassSource.class, (String)("public class " + plan.getClassName() + "<T extends " + plan.getClassName() + "<T>> {}"));
        type.setPackage(plan.getPackageName());
        JavaDocSource javaDoc = type.getJavaDoc();
        ResourceDescription desc = plan.getDescription();
        javaDoc.setText(desc.getText());
        this.addAddressAnnotations(type, plan);
        this.addConstructor(type, plan);
        this.addResourceTypeAnnotation(type, plan);
        this.addPropertyChangeSupport(type, plan);
        this.addChildResources(index, type, plan);
        this.addSingletonResources(index, type, plan);
        if (plan.getSubresourceClass() != null) {
            type.addNestedType((JavaSource)plan.getSubresourceClass());
        }
        for (EnumPlan enumPlan : plan.getEnumPlans()) {
            EnumFactory factory = new EnumFactory();
            JavaEnumSource enumType = factory.create(index, enumPlan);
            enumType.setStatic(true);
            type.addNestedType((JavaSource)enumType);
        }
        this.addAttribtues(index, type, plan);
        return type;
    }

    protected void addConstructor(JavaClassSource type, ClassPlan plan) {
        ((FieldSource)((FieldSource)type.addField().setName("key")).setPrivate()).setType(String.class);
        boolean isSingleton = plan.isSingleton();
        if (isSingleton) {
            ((MethodSource)type.addMethod().setConstructor(true).setPublic()).setBody("this.key = \"" + plan.getSingletonName() + "\";\n" + "this.pcs = new PropertyChangeSupport(this);");
        } else {
            ((MethodSource)type.addMethod().setConstructor(true).setPublic()).setBody("this.key = key;").addParameter(String.class, "key");
        }
        ((MethodSource)((MethodSource)type.addMethod().setName("getKey")).setPublic()).setReturnType(String.class).setBody("return this.key;");
    }

    protected void addAddressAnnotations(JavaClassSource type, ClassPlan plan) {
        AddressTemplate address = plan.getAddr();
        if (1 == plan.getAddresses().size()) {
            type.addImport(Address.class);
            AnnotationSource addressMeta = type.addAnnotation(Address.class);
            addressMeta.setStringValue(plan.getAddresses().get(0).toString());
        } else {
            type.addImport(Addresses.class);
            String[] addresses = new String[plan.getAddresses().size()];
            int i = 0;
            for (AddressTemplate addressTemplate : plan.getAddresses()) {
                addresses[i] = addressTemplate.toString();
                ++i;
            }
            AnnotationSource addressesMeta = type.addAnnotation(Addresses.class);
            addressesMeta.setStringArrayValue(addresses);
        }
    }

    protected void addResourceTypeAnnotation(JavaClassSource type, ClassPlan plan) {
        type.addImport(ResourceType.class);
        AnnotationSource typeAnno = type.addAnnotation();
        typeAnno.setName("ResourceType");
        typeAnno.setStringValue(plan.getResourceType());
        if (plan.isSingleton()) {
            type.addImport(Implicit.class);
            AnnotationSource implicitMeta = type.addAnnotation();
            implicitMeta.setName(Implicit.class.getSimpleName());
        }
    }

    protected void addPropertyChangeSupport(JavaClassSource type, ClassPlan plan) {
        ((FieldSource)type.addField().setName("pcs")).setType(PropertyChangeSupport.class).setPrivate();
        MethodSource listenerAdd = type.addMethod();
        listenerAdd.getJavaDoc().setText("Adds a property change listener");
        ((MethodSource)((MethodSource)listenerAdd.setPublic()).setName("addPropertyChangeListener")).addParameter(PropertyChangeListener.class, "listener");
        listenerAdd.setBody("if(null==this.pcs) this.pcs = new PropertyChangeSupport(this);\nthis.pcs.addPropertyChangeListener(listener);");
        MethodSource listenerRemove = type.addMethod();
        listenerRemove.getJavaDoc().setText("Removes a property change listener");
        ((MethodSource)((MethodSource)listenerRemove.setPublic()).setName("removePropertyChangeListener")).addParameter(PropertyChangeListener.class, "listener");
        listenerRemove.setBody("if(this.pcs!=null) this.pcs.removePropertyChangeListener(listener);");
    }

    protected void addAttribtues(ClassIndex index, JavaClassSource type, ClassPlan plan) {
        ResourceDescription desc = plan.getDescription();
        Inflector inflector = new Inflector();
        type.addImport(ModelNodeBinding.class);
        desc.getAttributes().forEach(att -> {
            if (this.names.contains(att.getName())) {
                System.err.println("WARNING: skipping attribute: " + att.getName() + ": conflicts with sub-resource");
                return;
            }
            ModelType modelType = ModelType.valueOf((String)att.getValue().get("type").asString());
            Optional resolvedType = Types.resolveJavaTypeName((ModelType)modelType, (ModelNode)att.getValue());
            if (resolvedType.isPresent() && !att.getValue().get("deprecated").isDefined()) {
                try {
                    String attributeType;
                    String name = ResourceFactory.javaAttributeName(att.getName());
                    if (modelType == ModelType.STRING && att.getValue().hasDefined("allowed")) {
                        boolean standaloneEnum = false;
                        EnumPlan enumPlan = plan.lookup((Property)att);
                        if (enumPlan == null) {
                            standaloneEnum = true;
                            enumPlan = index.lookup(plan, (Property)att);
                        }
                        String enumName = Character.toUpperCase(name.charAt(0)) + name.substring(1, name.length());
                        attributeType = enumPlan.getClassName();
                        type.addImport(Arrays.class);
                        if (standaloneEnum) {
                            type.addImport(enumPlan.getFullyQualifiedClassName());
                        }
                    } else {
                        attributeType = (String)resolvedType.get();
                    }
                    String attributeDescription = att.getValue().get("description").asString();
                    FieldSource attributeField = (FieldSource)((FieldSource)type.addField().setName(name)).setType(attributeType).setPrivate();
                    MethodSource accessor = type.addMethod();
                    accessor.getJavaDoc().setText(attributeDescription);
                    ((MethodSource)((MethodSource)accessor.setPublic()).setName(name)).setReturnType(attributeType).setBody("return this." + name + ";");
                    MethodSource mutator = type.addMethod();
                    mutator.getJavaDoc().setText(attributeDescription);
                    mutator.addParameter(attributeType, "value");
                    ((MethodSource)((MethodSource)mutator.setPublic()).setName(name)).setReturnType("T").setBody("Object oldValue = this." + name + ";\n" + "this." + name + " = value;\n" + "if(this.pcs!=null) this.pcs.firePropertyChange(\"" + name + "\", oldValue, value);\n" + "return (T) this;").addAnnotation("SuppressWarnings").setStringValue("unchecked");
                    AnnotationSource bindingMeta = accessor.addAnnotation();
                    bindingMeta.setName(ModelNodeBinding.class.getSimpleName());
                    bindingMeta.setStringValue("detypedName", att.getName());
                    if (modelType == ModelType.LIST) {
                        String singularName = inflector.singularize(name);
                        type.addImport(Arrays.class);
                        MethodSource appender = type.addMethod();
                        appender.getJavaDoc().setText(attributeDescription);
                        appender.addParameter(Types.resolveValueType((ModelNode)att.getValue()), "value");
                        ((MethodSource)((MethodSource)appender.setPublic()).setName(singularName)).setReturnType("T").setBody(" if ( this." + name + " == null ) { this." + name + " = new java.util.ArrayList<>(); }\nthis." + name + ".add(value);\nreturn (T) this;").addAnnotation("SuppressWarnings").setStringValue("unchecked");
                        MethodSource varargs = type.addMethod();
                        varargs.getJavaDoc().setText(attributeDescription);
                        varargs.addParameter(Types.resolveValueType((ModelNode)att.getValue()), "...args");
                        ((MethodSource)((MethodSource)varargs.setPublic()).setName(name)).setReturnType("T").setBody(name + "(Arrays.asList( args )); return (T) this;").addAnnotation("SuppressWarnings").setStringValue("unchecked");
                    } else if (modelType == ModelType.OBJECT) {
                        String singularName = inflector.singularize(name);
                        MethodSource appender = type.addMethod();
                        appender.getJavaDoc().setText(attributeDescription);
                        appender.addParameter(String.class, "key");
                        appender.addParameter(Object.class, "value");
                        ((MethodSource)((MethodSource)appender.setPublic()).setName(singularName)).setReturnType("T").setBody(" if ( this." + name + " == null ) { this." + name + " = new java.util.HashMap<>(); }\nthis." + name + ".put(key, value);\nreturn (T) this;").addAnnotation("SuppressWarnings").setStringValue("unchecked");
                    }
                }
                catch (Exception e) {
                    log.log((java.util.logging.Level)Level.ERROR, "Failed to process " + plan.getFullyQualifiedClassName() + ", attribute " + att.getName(), e);
                }
            }
        });
    }

    protected void addChildResources(ClassIndex index, JavaClassSource type, ClassPlan plan) {
        if (!plan.getDescription().getChildrenTypes().isEmpty()) {
            this.createChildAccessors(index, plan, type);
        }
    }

    protected void addSingletonResources(ClassIndex index, JavaClassSource type, ClassPlan plan) {
        if (!plan.getDescription().getSingletonChildrenTypes().isEmpty()) {
            this.createSingletonChildAccessors(index, plan, type);
        }
    }

    public void createChildAccessors(ClassIndex index, ClassPlan plan, JavaClassSource javaClass) {
        Inflector inflector = new Inflector();
        ResourceMetaData resourceMetaData = plan.getMetaData();
        JavaClassSource subresourceClass = this.getOrCreateSubresourceClass(plan, javaClass);
        ResourceDescription resourceMetaDataDescription = resourceMetaData.getDescription();
        Set<String> childrenNames = resourceMetaDataDescription.getChildrenTypes();
        for (String childName : childrenNames) {
            String propName;
            this.names.add(childName);
            AddressTemplate childAddress = resourceMetaData.getAddress().append(childName + "=*");
            ClassPlan childClass = index.lookup(childAddress);
            javaClass.addImport(childClass.getFullyQualifiedClassName() + "Consumer");
            javaClass.addImport(childClass.getFullyQualifiedClassName() + "Supplier");
            String childClassName = childClass.getClassName();
            javaClass.addImport(childClass.getFullyQualifiedClassName());
            String propType = "java.util.List<" + childClassName + ">";
            String singularName = propName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, Keywords.escape(childClass.getOriginalClassName()));
            String pluralName = inflector.pluralize(singularName);
            if (!propName.endsWith("s")) {
                propName = pluralName;
            }
            String resourceText = resourceMetaDataDescription.getChildDescription(childName).getText();
            ((FieldSource)((FieldSource)subresourceClass.addField().setName(propName)).setType(propType).setPrivate()).setLiteralInitializer("new java.util.ArrayList<>();").getJavaDoc().setText(resourceText);
            MethodSource accessor = subresourceClass.addMethod();
            accessor.getJavaDoc().setText("Get the list of " + childClassName + " resources").addTagValue("@return", "the list of resources");
            ((MethodSource)((MethodSource)accessor.setPublic()).setName(propName)).setReturnType(propType).setBody("return this." + propName + ";");
            MethodSource getByKey = subresourceClass.addMethod();
            getByKey.addParameter(String.class, "key");
            ((MethodSource)((MethodSource)getByKey.setPublic()).setName(singularName)).setReturnType(childClassName).setBody("return this." + propName + ".stream().filter( e->e.getKey().equals(key) ).findFirst().orElse(null);");
            MethodSource listMutator = javaClass.addMethod();
            listMutator.getJavaDoc().setText("Add all " + childClassName + " objects to this subresource").addTagValue("@return", "this").addTagValue("@param", "value List of " + childClassName + " objects.");
            listMutator.addParameter(propType, "value");
            ((MethodSource)((MethodSource)listMutator.setPublic()).setName(propName)).setReturnType("T").setBody("this.subresources." + propName + " = value;\nreturn (T) this;").addAnnotation("SuppressWarnings").setStringValue("unchecked");
            MethodSource mutator = javaClass.addMethod();
            mutator.getJavaDoc().setText("Add the " + childClassName + " object to the list of subresources").addTagValue("@param", "value The " + childClassName + " to add").addTagValue("@return", "this");
            mutator.addParameter(childClassName, "value");
            ((MethodSource)((MethodSource)mutator.setPublic()).setName(singularName)).setReturnType("T").setBody("this.subresources." + propName + ".add(value);\nreturn (T) this;").addAnnotation("SuppressWarnings").setStringValue("unchecked");
            MethodSource configurator = javaClass.addMethod();
            configurator.getJavaDoc().setText("Create and configure a " + childClassName + " object to the list of subresources").addTagValue("@param", "key The key for the " + childClassName + " resource").addTagValue("@param", "config The " + childClassName + "Consumer to use").addTagValue("@return", "this");
            configurator.addParameter(String.class, "childKey");
            configurator.addParameter(childClassName + "Consumer", "consumer");
            ((MethodSource)((MethodSource)configurator.setPublic()).setName(singularName)).setReturnType("T").setBody(childClassName + "<? extends " + childClassName + "> child = new " + childClassName + "<>(childKey);\n if ( consumer != null ) { consumer.accept(child); }\n" + singularName + "(child);\nreturn (T) this;").addAnnotation("SuppressWarnings").setStringValue("unchecked");
            MethodSource nonConfigurator = javaClass.addMethod();
            nonConfigurator.getJavaDoc().setText("Create and configure a " + childClassName + " object to the list of subresources").addTagValue("@param", "key The key for the " + childClassName + " resource").addTagValue("@return", "this");
            nonConfigurator.addParameter(String.class, "childKey");
            ((MethodSource)((MethodSource)nonConfigurator.setPublic()).setName(singularName)).setReturnType("T").setBody(singularName + "(childKey, null);\nreturn (T) this;\n").addAnnotation("SuppressWarnings").setStringValue("unchecked");
            MethodSource supplier = javaClass.addMethod();
            supplier.getJavaDoc().setText("Install a supplied " + childClassName + " object to the list of subresources");
            supplier.addParameter(childClassName + "Supplier", "supplier");
            ((MethodSource)((MethodSource)supplier.setPublic()).setName(singularName)).setReturnType("T").setBody(singularName + "(supplier.get()); return (T) this;").addAnnotation("SuppressWarnings").setStringValue("unchecked");
            AnnotationSource subresourceMeta = accessor.addAnnotation();
            subresourceMeta.setName("Subresource");
        }
    }

    public void createSingletonChildAccessors(ClassIndex index, ClassPlan plan, JavaClassSource javaClass) {
        ResourceMetaData resourceMetaData = plan.getMetaData();
        JavaClassSource subresourceClass = this.getOrCreateSubresourceClass(plan, javaClass);
        ResourceDescription description = resourceMetaData.getDescription();
        Set<String> singletonNames = description.getSingletonChildrenTypes();
        javaClass.addImport(Subresource.class);
        for (String singletonName : singletonNames) {
            String[] split = singletonName.split("=");
            String type = split[0];
            String name = split[1];
            AddressTemplate childAddress = resourceMetaData.getAddress().append(type + "=" + name);
            ClassPlan childClass = index.lookup(childAddress);
            String propName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, childClass.getOriginalClassName());
            ((FieldSource)subresourceClass.addField().setName(propName)).setType(childClass.getFullyQualifiedClassName()).setPrivate();
            MethodSource accessor = subresourceClass.addMethod();
            String javaDoc = description.getChildDescription(type, name).getText();
            accessor.getJavaDoc().setText(javaDoc);
            ((MethodSource)((MethodSource)accessor.setPublic()).setName(propName)).setReturnType(childClass.getFullyQualifiedClassName()).setBody("return this." + propName + ";");
            AnnotationSource subresourceMeta = accessor.addAnnotation();
            subresourceMeta.setName("Subresource");
            MethodSource mutator = javaClass.addMethod();
            mutator.getJavaDoc().setText(javaDoc);
            mutator.addParameter(childClass.getFullyQualifiedClassName(), "value");
            ((MethodSource)((MethodSource)mutator.setPublic()).setName(propName)).setReturnType("T").setBody("this.subresources." + propName + "=value;\nreturn (T) this;").addAnnotation("SuppressWarnings").setStringValue("unchecked");
            javaClass.addImport(childClass.getFullyQualifiedClassName() + "Consumer");
            javaClass.addImport(childClass.getFullyQualifiedClassName() + "Supplier");
            MethodSource consumer = javaClass.addMethod();
            consumer.getJavaDoc().setText(javaDoc);
            consumer.addParameter(childClass.getClassName() + "Consumer", "consumer");
            ((MethodSource)((MethodSource)consumer.setPublic()).setName(propName)).setReturnType("T").setBody(childClass.getClassName() + "<? extends " + childClass.getClassName() + "> child = new " + childClass.getClassName() + "<>();\n" + "if ( consumer != null ) { consumer.accept(child); }\n" + "this.subresources." + propName + " = child;\n" + "return (T) this;").addAnnotation("SuppressWarnings").setStringValue("unchecked");
            MethodSource noConfig = javaClass.addMethod();
            noConfig.getJavaDoc().setText(javaDoc);
            ((MethodSource)((MethodSource)noConfig.setPublic()).setName(propName)).setReturnType("T").setBody(childClass.getClassName() + "<? extends " + childClass.getClassName() + "> child = new " + childClass.getClassName() + "<>();\n" + "this.subresources." + propName + " = child;\n" + "return (T) this;").addAnnotation("SuppressWarnings").setStringValue("unchecked");
            MethodSource supplier = javaClass.addMethod();
            supplier.getJavaDoc().setText(javaDoc);
            supplier.addParameter(childClass.getClassName() + "Supplier", "supplier");
            ((MethodSource)((MethodSource)supplier.setPublic()).setName(propName)).setReturnType("T").setBody("this.subresources." + propName + " = supplier.get();\nreturn (T) this;").addAnnotation("SuppressWarnings").setStringValue("unchecked");
        }
    }

    private JavaClassSource getOrCreateSubresourceClass(ClassPlan plan, JavaClassSource javaClass) {
        JavaClassSource subresourceClass = plan.getSubresourceClass();
        if (subresourceClass != null) {
            return subresourceClass;
        }
        subresourceClass = (JavaClassSource)Roaster.parse(JavaClassSource.class, (String)("class " + javaClass.getName() + "Resources" + " {}"));
        subresourceClass.setPackage(plan.getPackageName());
        subresourceClass.getJavaDoc().setText("Child mutators for " + javaClass.getName());
        subresourceClass.setPublic();
        subresourceClass.setStatic(true);
        ((FieldSource)((FieldSource)javaClass.addField().setPrivate()).setType(subresourceClass.getName()).setName("subresources")).setLiteralInitializer("new " + subresourceClass.getName() + "();");
        MethodSource subresourcesMethod = (MethodSource)((MethodSource)javaClass.addMethod().setName("subresources")).setPublic();
        subresourcesMethod.setReturnType(subresourceClass.getName());
        subresourcesMethod.setBody("return this.subresources;");
        javaClass.addImport("java.util.List");
        javaClass.addImport(Subresource.class);
        plan.setSubresourceClass(subresourceClass);
        return subresourceClass;
    }

    public static final String javaAttributeName(String dmr) {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, Keywords.escape(dmr.replace("-", "_")));
    }
}

