/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.generator.generator;

import java.util.List;
import org.jboss.dmr.ModelNode;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.source.EnumConstantSource;
import org.jboss.forge.roaster.model.source.JavaEnumSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.wildfly.swarm.config.generator.generator.ClassIndex;
import org.wildfly.swarm.config.generator.generator.EnumPlan;

public class EnumFactory {
    public JavaEnumSource create(ClassIndex index, EnumPlan plan) {
        JavaEnumSource enumType = (JavaEnumSource)((JavaEnumSource)((JavaEnumSource)Roaster.create(JavaEnumSource.class)).setName(plan.getClassName())).setPublic();
        if (plan.getPackageName() != null) {
            enumType.setPackage(plan.getPackageName());
        }
        enumType.addProperty(String.class, "allowedValue").getAccessor().getJavaDoc().setText("Returns the allowed value for the management model.").addTagValue("@return", "the allowed model value");
        MethodSource constructor = enumType.addMethod().setConstructor(true);
        constructor.addParameter(String.class, "allowedValue");
        constructor.setBody("this.allowedValue = allowedValue;");
        ((MethodSource)((MethodSource)enumType.addMethod().setName("toString")).setReturnType(String.class).setPublic()).setBody("return allowedValue;").addAnnotation(Override.class);
        List<ModelNode> allowedValues = plan.getAllowedValues();
        allowedValues.forEach(value -> {
            String v = value.asString();
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (char c : v.toCharArray()) {
                switch (c) {
                    case '-': 
                    case '.': {
                        sb.append('_');
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        if (first) {
                            sb.append("_");
                        }
                        sb.append(c);
                        break;
                    }
                    default: {
                        sb.append(Character.toUpperCase(c));
                    }
                }
                first = false;
            }
            EnumConstantSource constantSource = enumType.addEnumConstant(EnumFactory.fixSingleDigitsInEnumName(sb.toString()));
            constantSource.setConstructorArguments(new String[]{"\"" + value.asString() + "\""});
        });
        return enumType;
    }

    static String fixSingleDigitsInEnumName(String input) {
        return input.replaceAll("^_1_", "ONE_").replaceAll("^_2_", "TWO_").replaceAll("^_3_", "THREE_").replaceAll("^_4_", "FOUR_").replaceAll("^_5_", "FIVE_").replaceAll("^_6_", "SIX_").replaceAll("^_7_", "SEVEN_").replaceAll("^_8_", "EIGHT_").replaceAll("^_9_", "NINE_").replaceAll("^_10_", "TEN_");
    }
}

