/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.runtime.invocation;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.MethodInfo;
import org.wildfly.config.model.NoopContext;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.invocation.IndexFactory;
import org.wildfly.swarm.config.runtime.invocation.ListTypeAdapter;
import org.wildfly.swarm.config.runtime.invocation.MapTypeAdapter;
import org.wildfly.swarm.config.runtime.invocation.SimpleTypeAdapter;
import org.wildfly.swarm.config.runtime.invocation.Types;
import org.wildfly.swarm.config.runtime.model.AddressTemplate;
import org.wildfly.swarm.config.runtime.model.StatementContext;

public class EntityAdapter<T> {
    private Class<?> type;
    private Index index;
    private static final StatementContext NOOP_CTX = new NoopContext();

    public EntityAdapter(Class<?> type) {
        this.type = type;
        this.index = IndexFactory.createIndex(type);
    }

    private Class<?> getType() {
        return this.type;
    }

    public Index getIndex() {
        return this.index;
    }

    public boolean isBaseTypeAdapter() {
        return this.isBaseType(this.getType());
    }

    public boolean isBaseType(Class<?> clazz) {
        return clazz == String.class || clazz == Long.class || clazz == Integer.class || clazz == Boolean.class || clazz == Double.class || clazz == BigDecimal.class || clazz == byte[].class;
    }

    private T convertToBaseType(ModelNode dmr) {
        if (this.getType() == String.class) {
            return (T)dmr.asString();
        }
        if (this.getType() == Long.class) {
            return (T)Long.valueOf(dmr.asLong());
        }
        if (this.getType() == Integer.class) {
            return (T)Integer.valueOf(dmr.asInt());
        }
        if (this.getType() == Boolean.class) {
            return (T)Boolean.valueOf(dmr.asBoolean());
        }
        if (this.getType() == Double.class) {
            return (T)Double.valueOf(dmr.asDouble());
        }
        if (this.getType() == BigDecimal.class) {
            return (T)BigDecimal.valueOf(dmr.asDouble());
        }
        if (this.getType() == byte[].class) {
            return (T)dmr.asBytes();
        }
        throw new IllegalArgumentException("Can not convert. This node is not of a base type. Actual type is " + this.type.getName());
    }

    public T fromDMR(String keyValue, ModelNode modelNode) throws Exception {
        if (this.isBaseTypeAdapter()) {
            return this.convertToBaseType(modelNode);
        }
        ModelNode actualPayload = null;
        if (!ModelType.OBJECT.equals((Object)modelNode.getType())) {
            throw new IllegalArgumentException("Unsupported ModelType " + modelNode.getType() + ": " + modelNode);
        }
        actualPayload = modelNode;
        ClassInfo clazz = this.index.getClassByName(DotName.createSimple((String)this.getType().getCanonicalName()));
        Object entity = null;
        boolean implicitKey = clazz.annotations().containsKey(IndexFactory.IMPLICIT_META);
        if (implicitKey) {
            Constructor<?> ctor = this.getType().getConstructor(new Class[0]);
            entity = ctor.newInstance(new Object[0]);
        } else {
            entity = this.getType().getConstructor(String.class).newInstance(keyValue);
        }
        for (MethodInfo method : clazz.methods()) {
            if (!method.hasAnnotation(IndexFactory.BINDING_META)) continue;
            Method getter = entity.getClass().getMethod(method.name(), new Class[0]);
            Class<?> propertyType = getter.getReturnType();
            ModelNodeBinding binding = getter.getDeclaredAnnotation(ModelNodeBinding.class);
            String detypedName = binding.detypedName();
            ModelNode dmrPayload = actualPayload.get(detypedName);
            ModelType dmrType = Types.resolveModelType(propertyType);
            if (dmrType == ModelType.LIST) {
                new ListTypeAdapter().fromDmr(entity, method.name(), dmrType, propertyType, dmrPayload);
                continue;
            }
            if (dmrType == ModelType.OBJECT) {
                new MapTypeAdapter().fromDmr(entity, method.name(), dmrType, propertyType, dmrPayload);
                continue;
            }
            new SimpleTypeAdapter().fromDmr(entity, method.name(), dmrType, propertyType, dmrPayload);
        }
        return (T)entity;
    }

    public ModelNode fromChangeset(Map<String, Object> changeSet, String ... wildcards) {
        ClassInfo clazz = null;
        Class<?> currentType = this.getType();
        while (clazz == null) {
            clazz = this.index.getClassByName(DotName.createSimple((String)currentType.getCanonicalName()));
            if (clazz != null || (currentType = currentType.getSuperclass()) != null) continue;
            throw new RuntimeException("Unable to determine ClassInfo");
        }
        Address addressMeta = currentType.getDeclaredAnnotation(Address.class);
        AddressTemplate address = AddressTemplate.of(addressMeta.value());
        ModelNode protoType = new ModelNode();
        protoType.get("address").set((ModelNode)address.resolve(NOOP_CTX, wildcards));
        protoType.get("operation").set("write-attribute");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("composite");
        operation.get("address").setEmptyList();
        ArrayList<ModelNode> steps = new ArrayList<ModelNode>();
        for (MethodInfo method : clazz.methods()) {
            if (!method.hasAnnotation(IndexFactory.BINDING_META)) continue;
            try {
                Method target = currentType.getMethod(method.name(), new Class[0]);
                Class<?> propertyType = target.getReturnType();
                ModelNodeBinding binding = target.getDeclaredAnnotation(ModelNodeBinding.class);
                String detypedName = binding.detypedName();
                String javaPropName = method.name();
                Object value = changeSet.get(javaPropName);
                if (value == null) continue;
                ModelNode step = protoType.clone();
                step.get("name").set(javaPropName);
                ModelNode modelNode = step.get("value");
                try {
                    ModelType dmrType = Types.resolveModelType(propertyType);
                    if (dmrType == ModelType.LIST) {
                        new ListTypeAdapter().toDmr(modelNode, detypedName, (List)value);
                    } else if (dmrType == ModelType.OBJECT) {
                        new MapTypeAdapter().toDmr(modelNode, detypedName, (Map)value);
                    } else {
                        new SimpleTypeAdapter().toDmr(modelNode, detypedName, dmrType, value);
                    }
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("Failed to adopt value " + propertyType.getName(), e);
                }
                steps.add(step);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        operation.get("steps").set(steps);
        return operation;
    }

    public ModelNode fromEntity(T entity) throws Exception {
        return this.fromEntity(entity, new ModelNode());
    }

    public ModelNode fromEntity(T entity, ModelNode modelNode) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ModelNode node;
        ModelNode addr = modelNode.get("address");
        if (addr.getType().equals((Object)ModelType.LIST) && addr.asList().size() == 1 && (node = addr.get(0)).getType().equals((Object)ModelType.PROPERTY) && node.asProperty().getName().equals("core-service")) {
            return null;
        }
        ClassInfo clazz = null;
        Class<?> currentType = this.getType();
        while (clazz == null) {
            clazz = this.index.getClassByName(DotName.createSimple((String)currentType.getCanonicalName()));
            if (clazz != null || (currentType = currentType.getSuperclass()) != null) continue;
            throw new RuntimeException("Unable to determine ClassInfo");
        }
        while (clazz != null) {
            for (MethodInfo method : clazz.methods()) {
                if (!method.hasAnnotation(IndexFactory.BINDING_META)) continue;
                Method target = entity.getClass().getMethod(method.name(), new Class[0]);
                Class<?> propertyType = target.getReturnType();
                Object propertyValue = target.invoke(entity, new Object[0]);
                AnnotationInstance ann = method.annotation(DotName.createSimple((String)ModelNodeBinding.class.getName()));
                AnnotationValue annValue = ann.value("detypedName");
                String detypedName = annValue.asString();
                if (propertyValue == null) continue;
                try {
                    ModelType dmrType = Types.resolveModelType(propertyType);
                    if (dmrType == ModelType.LIST) {
                        new ListTypeAdapter().toDmr(modelNode, detypedName, (List)propertyValue);
                        continue;
                    }
                    if (dmrType == ModelType.OBJECT) {
                        new MapTypeAdapter().toDmr(modelNode, detypedName, (Map)propertyValue);
                        continue;
                    }
                    new SimpleTypeAdapter().toDmr(modelNode, detypedName, dmrType, propertyValue);
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("Failed to adopt value " + propertyType.getName(), e);
                }
            }
            if (currentType.getSuperclass() != null && (currentType = currentType.getSuperclass()).equals(Object.class)) break;
            clazz = this.index.getClassByName(DotName.createSimple((String)currentType.getCanonicalName()));
        }
        return modelNode;
    }
}

