/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.runtime.invocation;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class Types<T> {
    private static final Logger logger = Logger.getLogger(Types.class.getName());

    public static Optional<String> resolveJavaTypeName(ModelType modelType, ModelNode value) {
        Optional<String> result = Optional.empty();
        if (ModelType.STRING == modelType) {
            result = Optional.of("java.lang.String");
        } else if (ModelType.INT == modelType) {
            result = Optional.of("java.lang.Integer");
        } else if (ModelType.LONG == modelType) {
            result = Optional.of("java.lang.Long");
        } else if (ModelType.BOOLEAN == modelType) {
            result = Optional.of("java.lang.Boolean");
        } else if (ModelType.DOUBLE == modelType) {
            result = Optional.of("java.lang.Double");
        } else if (ModelType.BIG_DECIMAL == modelType) {
            result = Optional.of("java.math.BigDecimal");
        } else if (ModelType.OBJECT == modelType) {
            result = Optional.of("java.util.Map");
        } else if (ModelType.LIST == modelType) {
            String templatedType = "<?>";
            ModelNode valueTypeNode = value.get("value-type");
            if (valueTypeNode.getType() == ModelType.OBJECT) {
                templatedType = "<java.util.Map>";
            } else {
                ModelType type = valueTypeNode.asType();
                if (type == ModelType.STRING) {
                    templatedType = "<String>";
                }
            }
            result = Optional.of("java.util.List" + templatedType);
        } else {
            logger.warning("Unsupported type " + modelType);
        }
        return result;
    }

    public static ModelType resolveModelType(Class<?> javaType) {
        ModelType type = null;
        if (String.class.equals(javaType)) {
            type = ModelType.STRING;
        } else if (Integer.class.equals(javaType)) {
            type = ModelType.INT;
        } else if (Long.class.equals(javaType)) {
            type = ModelType.LONG;
        } else if (Boolean.class.equals(javaType)) {
            type = ModelType.BOOLEAN;
        } else if (Double.class.equals(javaType)) {
            type = ModelType.DOUBLE;
        } else if (BigDecimal.class.equals(javaType)) {
            type = ModelType.BIG_DECIMAL;
        } else if (List.class.equals(javaType)) {
            type = ModelType.LIST;
        } else if (Map.class.equals(javaType)) {
            type = ModelType.OBJECT;
        } else {
            throw new RuntimeException("Failed to resolve ModelType for '" + javaType.getName() + "'");
        }
        return type;
    }
}

