/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.runtime.invocation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.swarm.config.runtime.invocation.Types;

public class ListTypeAdapter {
    public void toDmr(ModelNode modelMode, String detypedName, List value) {
        if (value.isEmpty()) {
            modelMode.get(detypedName).setEmptyList();
        } else {
            value.forEach(v -> {
                ModelType listValueType = Types.resolveModelType(v.getClass());
                this.addDmrValueTo(modelMode.get(detypedName), listValueType, v);
            });
        }
    }

    private void addDmrValueTo(ModelNode target, ModelType type, Object propValue) {
        if (type.equals((Object)ModelType.STRING)) {
            target.add((String)propValue);
        } else if (type.equals((Object)ModelType.INT)) {
            target.add(((Integer)propValue).intValue());
        } else if (type.equals((Object)ModelType.DOUBLE)) {
            target.add(((Double)propValue).doubleValue());
        } else if (type.equals((Object)ModelType.LONG)) {
            target.add(((Long)propValue).longValue());
        } else if (type.equals((Object)ModelType.BOOLEAN)) {
            target.add(((Boolean)propValue).booleanValue());
        } else if (type.equals((Object)ModelType.OBJECT)) {
            ModelNode val = target.addEmptyObject();
            Map map = (Map)propValue;
            for (String key : map.keySet()) {
                Object value = map.get(key);
                if (value instanceof String) {
                    val.get(key).set((String)value);
                    continue;
                }
                if (!(value instanceof Boolean)) continue;
                val.get(key).set(((Boolean)value).booleanValue());
            }
        } else {
            throw new RuntimeException("Unsupported DMR type: " + type);
        }
    }

    public void fromDmr(Object entity, String javaName, ModelType dmrType, Class<?> propertyType, ModelNode dmrPayload) throws Exception {
        List items;
        Method target = entity.getClass().getMethod(javaName, propertyType);
        List list = items = dmrPayload.isDefined() ? dmrPayload.asList() : Collections.EMPTY_LIST;
        if (items.isEmpty()) {
            target.invoke(entity, Collections.EMPTY_LIST);
        } else {
            ArrayList list2 = new ArrayList(items.size());
            ModelType listValueType = ((ModelNode)items.get(0)).getType();
            for (ModelNode item : items) {
                this.addJavaValueTo(list2, listValueType, item);
            }
            target.invoke(entity, list2);
        }
    }

    private void addJavaValueTo(List target, ModelType type, ModelNode propValue) {
        if (type.equals((Object)ModelType.STRING)) {
            target.add(propValue.asString());
        } else if (type.equals((Object)ModelType.INT)) {
            target.add(propValue.asInt());
        } else if (type.equals((Object)ModelType.DOUBLE)) {
            target.add(propValue.asDouble());
        } else if (type.equals((Object)ModelType.LONG)) {
            target.add(propValue.asLong());
        } else if (type.equals((Object)ModelType.BOOLEAN)) {
            target.add(propValue.asBoolean());
        } else {
            throw new RuntimeException("Unsupported DMR type: " + type);
        }
    }
}

