package org.wildfly.swarm.config;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.remoting.HttpConnector;
import org.wildfly.swarm.config.remoting.HttpConnectorConfigurator;
import org.wildfly.swarm.config.remoting.Connector;
import org.wildfly.swarm.config.remoting.ConnectorConfigurator;
import org.wildfly.swarm.config.remoting.OutboundConnection;
import org.wildfly.swarm.config.remoting.OutboundConnectionConfigurator;
import org.wildfly.swarm.config.remoting.LocalOutboundConnection;
import org.wildfly.swarm.config.remoting.LocalOutboundConnectionConfigurator;
import org.wildfly.swarm.config.remoting.RemoteOutboundConnection;
import org.wildfly.swarm.config.remoting.RemoteOutboundConnectionConfigurator;
import org.wildfly.swarm.config.remoting.EndpointConfiguration;
/**
 * The configuration of the Remoting subsystem.
 */
@ResourceType("subsystem")
@Implicit
public class Remoting<T extends Remoting> {

	private String key;
	private RemotingResources subresources = new RemotingResources();
	private EndpointConfiguration endpointConfiguration;

	public Remoting() {
		this.key = "remoting";
	}

	public String getKey() {
		return this.key;
	}

	public RemotingResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.remoting.HttpConnector objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.remoting.HttpConnector objects.
	 */
	@SuppressWarnings("unchecked")
	public T httpConnectors(
			List<org.wildfly.swarm.config.remoting.HttpConnector> value) {
		this.subresources.httpConnectors.addAll(value);
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.remoting.HttpConnector object to the list of subresources
	 * @param value The org.wildfly.swarm.config.remoting.HttpConnector to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpConnector(HttpConnector value) {
		this.subresources.httpConnectors.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.remoting.HttpConnector object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.remoting.HttpConnector resource
	 * @param config The org.wildfly.swarm.config.remoting.HttpConnectorConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpConnector(String childKey, HttpConnectorConfigurator config) {
		org.wildfly.swarm.config.remoting.HttpConnector child = new org.wildfly.swarm.config.remoting.HttpConnector(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		httpConnector(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.remoting.HttpConnector object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.remoting.HttpConnector resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpConnector(String childKey) {
		httpConnector(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.remoting.Connector objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.remoting.Connector objects.
	 */
	@SuppressWarnings("unchecked")
	public T connectors(List<org.wildfly.swarm.config.remoting.Connector> value) {
		this.subresources.connectors.addAll(value);
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.remoting.Connector object to the list of subresources
	 * @param value The org.wildfly.swarm.config.remoting.Connector to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connector(Connector value) {
		this.subresources.connectors.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.remoting.Connector object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.remoting.Connector resource
	 * @param config The org.wildfly.swarm.config.remoting.ConnectorConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connector(String childKey, ConnectorConfigurator config) {
		org.wildfly.swarm.config.remoting.Connector child = new org.wildfly.swarm.config.remoting.Connector(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		connector(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.remoting.Connector object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.remoting.Connector resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connector(String childKey) {
		connector(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.remoting.OutboundConnection objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.remoting.OutboundConnection objects.
	 */
	@SuppressWarnings("unchecked")
	public T outboundConnections(
			List<org.wildfly.swarm.config.remoting.OutboundConnection> value) {
		this.subresources.outboundConnections.addAll(value);
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.remoting.OutboundConnection object to the list of subresources
	 * @param value The org.wildfly.swarm.config.remoting.OutboundConnection to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T outboundConnection(OutboundConnection value) {
		this.subresources.outboundConnections.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.remoting.OutboundConnection object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.remoting.OutboundConnection resource
	 * @param config The org.wildfly.swarm.config.remoting.OutboundConnectionConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T outboundConnection(String childKey,
			OutboundConnectionConfigurator config) {
		org.wildfly.swarm.config.remoting.OutboundConnection child = new org.wildfly.swarm.config.remoting.OutboundConnection(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		outboundConnection(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.remoting.OutboundConnection object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.remoting.OutboundConnection resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T outboundConnection(String childKey) {
		outboundConnection(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.remoting.LocalOutboundConnection objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.remoting.LocalOutboundConnection objects.
	 */
	@SuppressWarnings("unchecked")
	public T localOutboundConnections(
			List<org.wildfly.swarm.config.remoting.LocalOutboundConnection> value) {
		this.subresources.localOutboundConnections.addAll(value);
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.remoting.LocalOutboundConnection object to the list of subresources
	 * @param value The org.wildfly.swarm.config.remoting.LocalOutboundConnection to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T localOutboundConnection(LocalOutboundConnection value) {
		this.subresources.localOutboundConnections.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.remoting.LocalOutboundConnection object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.remoting.LocalOutboundConnection resource
	 * @param config The org.wildfly.swarm.config.remoting.LocalOutboundConnectionConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T localOutboundConnection(String childKey,
			LocalOutboundConnectionConfigurator config) {
		org.wildfly.swarm.config.remoting.LocalOutboundConnection child = new org.wildfly.swarm.config.remoting.LocalOutboundConnection(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		localOutboundConnection(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.remoting.LocalOutboundConnection object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.remoting.LocalOutboundConnection resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T localOutboundConnection(String childKey) {
		localOutboundConnection(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.remoting.RemoteOutboundConnection objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.remoting.RemoteOutboundConnection objects.
	 */
	@SuppressWarnings("unchecked")
	public T remoteOutboundConnections(
			List<org.wildfly.swarm.config.remoting.RemoteOutboundConnection> value) {
		this.subresources.remoteOutboundConnections.addAll(value);
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.remoting.RemoteOutboundConnection object to the list of subresources
	 * @param value The org.wildfly.swarm.config.remoting.RemoteOutboundConnection to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteOutboundConnection(RemoteOutboundConnection value) {
		this.subresources.remoteOutboundConnections.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.remoting.RemoteOutboundConnection object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.remoting.RemoteOutboundConnection resource
	 * @param config The org.wildfly.swarm.config.remoting.RemoteOutboundConnectionConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteOutboundConnection(String childKey,
			RemoteOutboundConnectionConfigurator config) {
		org.wildfly.swarm.config.remoting.RemoteOutboundConnection child = new org.wildfly.swarm.config.remoting.RemoteOutboundConnection(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		remoteOutboundConnection(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.remoting.RemoteOutboundConnection object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.remoting.RemoteOutboundConnection resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteOutboundConnection(String childKey) {
		remoteOutboundConnection(childKey, null);
		return (T) this;
	}

	/**
	 * Child mutators for Remoting
	 */
	public class RemotingResources {
		/**
		 * The configuration of a HTTP Upgrade based Remoting connector.
		 */
		private List<org.wildfly.swarm.config.remoting.HttpConnector> httpConnectors = new java.util.ArrayList<>();
		/**
		 * The configuration of a Remoting connector.
		 */
		private List<org.wildfly.swarm.config.remoting.Connector> connectors = new java.util.ArrayList<>();
		/**
		 * Remoting outbound connection.
		 */
		private List<org.wildfly.swarm.config.remoting.OutboundConnection> outboundConnections = new java.util.ArrayList<>();
		/**
		 * Remoting outbound connection with an implicit local:// URI scheme.
		 */
		private List<org.wildfly.swarm.config.remoting.LocalOutboundConnection> localOutboundConnections = new java.util.ArrayList<>();
		/**
		 * Remoting outbound connection with an implicit remote:// URI scheme.
		 */
		private List<org.wildfly.swarm.config.remoting.RemoteOutboundConnection> remoteOutboundConnections = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.remoting.HttpConnector resources
		 * @return the list of resources
		 */
		@Subresource
		public List<HttpConnector> httpConnectors() {
			return this.httpConnectors;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.remoting.Connector resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Connector> connectors() {
			return this.connectors;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.remoting.OutboundConnection resources
		 * @return the list of resources
		 */
		@Subresource
		public List<OutboundConnection> outboundConnections() {
			return this.outboundConnections;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.remoting.LocalOutboundConnection resources
		 * @return the list of resources
		 */
		@Subresource
		public List<LocalOutboundConnection> localOutboundConnections() {
			return this.localOutboundConnections;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.remoting.RemoteOutboundConnection resources
		 * @return the list of resources
		 */
		@Subresource
		public List<RemoteOutboundConnection> remoteOutboundConnections() {
			return this.remoteOutboundConnections;
		}
	}

	/**
	 * Endpoint configuration
	 */
	@Subresource
	public EndpointConfiguration endpointConfiguration() {
		return this.endpointConfiguration;
	}

	/**
	 * Endpoint configuration
	 */
	@SuppressWarnings("unchecked")
	public T endpointConfiguration(EndpointConfiguration value) {
		this.endpointConfiguration = value;
		return (T) this;
	}
}