package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * The state transfer configuration for distributed and replicated caches.
 */
@ResourceType("component")
@Implicit
public class StateTransferComponent<T extends StateTransferComponent> {

	private String key;
	private Integer chunkSize;
	private Long timeout;

	public StateTransferComponent() {
		this.key = "state-transfer";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The size, in bytes, in which to batch the transfer of cache entries.
	 */
	@ModelNodeBinding(detypedName = "chunk-size")
	public Integer chunkSize() {
		return this.chunkSize;
	}

	/**
	 * The size, in bytes, in which to batch the transfer of cache entries.
	 */
	@SuppressWarnings("unchecked")
	public StateTransferComponent chunkSize(Integer value) {
		this.chunkSize = value;
		return (StateTransferComponent) this;
	}

	/**
	 * The maximum amount of time (ms) to wait for state from neighboring caches, before throwing an exception and aborting startup.
	 */
	@ModelNodeBinding(detypedName = "timeout")
	public Long timeout() {
		return this.timeout;
	}

	/**
	 * The maximum amount of time (ms) to wait for state from neighboring caches, before throwing an exception and aborting startup.
	 */
	@SuppressWarnings("unchecked")
	public StateTransferComponent timeout(Long value) {
		this.timeout = value;
		return (StateTransferComponent) this;
	}
}