package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * Defines a thread pool used for asynchronous transport communication.
 */
@ResourceType("thread-pool")
@Implicit
public class TransportThreadPool<T extends TransportThreadPool> {

	private String key;
	private Long keepaliveTime;
	private Integer maxThreads;
	private Integer minThreads;
	private Integer queueLength;

	public TransportThreadPool() {
		this.key = "transport";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Used to specify the amount of milliseconds that pool threads should be kept running when idle; if not specified, threads will run until the executor is shut down.
	 */
	@ModelNodeBinding(detypedName = "keepalive-time")
	public Long keepaliveTime() {
		return this.keepaliveTime;
	}

	/**
	 * Used to specify the amount of milliseconds that pool threads should be kept running when idle; if not specified, threads will run until the executor is shut down.
	 */
	@SuppressWarnings("unchecked")
	public TransportThreadPool keepaliveTime(Long value) {
		this.keepaliveTime = value;
		return (TransportThreadPool) this;
	}

	/**
	 * The maximum thread pool size.
	 */
	@ModelNodeBinding(detypedName = "max-threads")
	public Integer maxThreads() {
		return this.maxThreads;
	}

	/**
	 * The maximum thread pool size.
	 */
	@SuppressWarnings("unchecked")
	public TransportThreadPool maxThreads(Integer value) {
		this.maxThreads = value;
		return (TransportThreadPool) this;
	}

	/**
	 * The core thread pool size which is smaller than the maximum pool size. If undefined, the core thread pool size is the same as the maximum thread pool size.
	 */
	@ModelNodeBinding(detypedName = "min-threads")
	public Integer minThreads() {
		return this.minThreads;
	}

	/**
	 * The core thread pool size which is smaller than the maximum pool size. If undefined, the core thread pool size is the same as the maximum thread pool size.
	 */
	@SuppressWarnings("unchecked")
	public TransportThreadPool minThreads(Integer value) {
		this.minThreads = value;
		return (TransportThreadPool) this;
	}

	/**
	 * The queue length.
	 */
	@ModelNodeBinding(detypedName = "queue-length")
	public Integer queueLength() {
		return this.queueLength;
	}

	/**
	 * The queue length.
	 */
	@SuppressWarnings("unchecked")
	public TransportThreadPool queueLength(Integer value) {
		this.queueLength = value;
		return (TransportThreadPool) this;
	}
}