package org.wildfly.swarm.config.logging;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
/**
 * The configuration of the logging subsystem.
 */
@ResourceType("logging-profile")
public class LoggingProfile<T extends LoggingProfile> {

	private String key;
	private LoggingProfileResources subresources = new LoggingProfileResources();
	private RootLogger rootLogger;

	public LoggingProfile(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	public LoggingProfileResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.logging.PeriodicRotatingFileHandler objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.logging.PeriodicRotatingFileHandler objects.
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile periodicRotatingFileHandlers(
			List<org.wildfly.swarm.config.logging.PeriodicRotatingFileHandler> value) {
		this.subresources.periodicRotatingFileHandlers.addAll(value);
		return (LoggingProfile) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.logging.PeriodicRotatingFileHandler object to the list of subresources
	 * @param value The org.wildfly.swarm.config.logging.PeriodicRotatingFileHandler to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile periodicRotatingFileHandler(
			PeriodicRotatingFileHandler value) {
		this.subresources.periodicRotatingFileHandlers.add(value);
		return (LoggingProfile) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.logging.PeriodicRotatingFileHandler object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.logging.PeriodicRotatingFileHandler resource
	 * @param config The org.wildfly.swarm.config.logging.PeriodicRotatingFileHandlerConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile periodicRotatingFileHandler(String childKey,
			PeriodicRotatingFileHandlerConfigurator config) {
		org.wildfly.swarm.config.logging.PeriodicRotatingFileHandler child = new org.wildfly.swarm.config.logging.PeriodicRotatingFileHandler(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		periodicRotatingFileHandler(child);
		return (LoggingProfile) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.logging.PeriodicRotatingFileHandler object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.logging.PeriodicRotatingFileHandler resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile periodicRotatingFileHandler(String childKey) {
		periodicRotatingFileHandler(childKey, null);
		return (LoggingProfile) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.logging.CustomFormatter objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.logging.CustomFormatter objects.
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile customFormatters(
			List<org.wildfly.swarm.config.logging.CustomFormatter> value) {
		this.subresources.customFormatters.addAll(value);
		return (LoggingProfile) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.logging.CustomFormatter object to the list of subresources
	 * @param value The org.wildfly.swarm.config.logging.CustomFormatter to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile customFormatter(CustomFormatter value) {
		this.subresources.customFormatters.add(value);
		return (LoggingProfile) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.logging.CustomFormatter object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.logging.CustomFormatter resource
	 * @param config The org.wildfly.swarm.config.logging.CustomFormatterConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile customFormatter(String childKey,
			CustomFormatterConfigurator config) {
		org.wildfly.swarm.config.logging.CustomFormatter child = new org.wildfly.swarm.config.logging.CustomFormatter(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		customFormatter(child);
		return (LoggingProfile) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.logging.CustomFormatter object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.logging.CustomFormatter resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile customFormatter(String childKey) {
		customFormatter(childKey, null);
		return (LoggingProfile) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.logging.PeriodicSizeRotatingFileHandler objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.logging.PeriodicSizeRotatingFileHandler objects.
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile periodicSizeRotatingFileHandlers(
			List<org.wildfly.swarm.config.logging.PeriodicSizeRotatingFileHandler> value) {
		this.subresources.periodicSizeRotatingFileHandlers.addAll(value);
		return (LoggingProfile) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.logging.PeriodicSizeRotatingFileHandler object to the list of subresources
	 * @param value The org.wildfly.swarm.config.logging.PeriodicSizeRotatingFileHandler to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile periodicSizeRotatingFileHandler(
			PeriodicSizeRotatingFileHandler value) {
		this.subresources.periodicSizeRotatingFileHandlers.add(value);
		return (LoggingProfile) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.logging.PeriodicSizeRotatingFileHandler object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.logging.PeriodicSizeRotatingFileHandler resource
	 * @param config The org.wildfly.swarm.config.logging.PeriodicSizeRotatingFileHandlerConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile periodicSizeRotatingFileHandler(String childKey,
			PeriodicSizeRotatingFileHandlerConfigurator config) {
		org.wildfly.swarm.config.logging.PeriodicSizeRotatingFileHandler child = new org.wildfly.swarm.config.logging.PeriodicSizeRotatingFileHandler(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		periodicSizeRotatingFileHandler(child);
		return (LoggingProfile) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.logging.PeriodicSizeRotatingFileHandler object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.logging.PeriodicSizeRotatingFileHandler resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile periodicSizeRotatingFileHandler(String childKey) {
		periodicSizeRotatingFileHandler(childKey, null);
		return (LoggingProfile) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.logging.ConsoleHandler objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.logging.ConsoleHandler objects.
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile consoleHandlers(
			List<org.wildfly.swarm.config.logging.ConsoleHandler> value) {
		this.subresources.consoleHandlers.addAll(value);
		return (LoggingProfile) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.logging.ConsoleHandler object to the list of subresources
	 * @param value The org.wildfly.swarm.config.logging.ConsoleHandler to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile consoleHandler(ConsoleHandler value) {
		this.subresources.consoleHandlers.add(value);
		return (LoggingProfile) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.logging.ConsoleHandler object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.logging.ConsoleHandler resource
	 * @param config The org.wildfly.swarm.config.logging.ConsoleHandlerConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile consoleHandler(String childKey,
			ConsoleHandlerConfigurator config) {
		org.wildfly.swarm.config.logging.ConsoleHandler child = new org.wildfly.swarm.config.logging.ConsoleHandler(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		consoleHandler(child);
		return (LoggingProfile) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.logging.ConsoleHandler object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.logging.ConsoleHandler resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile consoleHandler(String childKey) {
		consoleHandler(childKey, null);
		return (LoggingProfile) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.logging.Logger objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.logging.Logger objects.
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile loggers(
			List<org.wildfly.swarm.config.logging.Logger> value) {
		this.subresources.loggers.addAll(value);
		return (LoggingProfile) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.logging.Logger object to the list of subresources
	 * @param value The org.wildfly.swarm.config.logging.Logger to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile logger(Logger value) {
		this.subresources.loggers.add(value);
		return (LoggingProfile) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.logging.Logger object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.logging.Logger resource
	 * @param config The org.wildfly.swarm.config.logging.LoggerConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile logger(String childKey, LoggerConfigurator config) {
		org.wildfly.swarm.config.logging.Logger child = new org.wildfly.swarm.config.logging.Logger(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		logger(child);
		return (LoggingProfile) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.logging.Logger object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.logging.Logger resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile logger(String childKey) {
		logger(childKey, null);
		return (LoggingProfile) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.logging.AsyncHandler objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.logging.AsyncHandler objects.
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile asyncHandlers(
			List<org.wildfly.swarm.config.logging.AsyncHandler> value) {
		this.subresources.asyncHandlers.addAll(value);
		return (LoggingProfile) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.logging.AsyncHandler object to the list of subresources
	 * @param value The org.wildfly.swarm.config.logging.AsyncHandler to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile asyncHandler(AsyncHandler value) {
		this.subresources.asyncHandlers.add(value);
		return (LoggingProfile) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.logging.AsyncHandler object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.logging.AsyncHandler resource
	 * @param config The org.wildfly.swarm.config.logging.AsyncHandlerConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile asyncHandler(String childKey,
			AsyncHandlerConfigurator config) {
		org.wildfly.swarm.config.logging.AsyncHandler child = new org.wildfly.swarm.config.logging.AsyncHandler(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		asyncHandler(child);
		return (LoggingProfile) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.logging.AsyncHandler object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.logging.AsyncHandler resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile asyncHandler(String childKey) {
		asyncHandler(childKey, null);
		return (LoggingProfile) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.logging.FileHandler objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.logging.FileHandler objects.
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile fileHandlers(
			List<org.wildfly.swarm.config.logging.FileHandler> value) {
		this.subresources.fileHandlers.addAll(value);
		return (LoggingProfile) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.logging.FileHandler object to the list of subresources
	 * @param value The org.wildfly.swarm.config.logging.FileHandler to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile fileHandler(FileHandler value) {
		this.subresources.fileHandlers.add(value);
		return (LoggingProfile) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.logging.FileHandler object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.logging.FileHandler resource
	 * @param config The org.wildfly.swarm.config.logging.FileHandlerConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile fileHandler(String childKey,
			FileHandlerConfigurator config) {
		org.wildfly.swarm.config.logging.FileHandler child = new org.wildfly.swarm.config.logging.FileHandler(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		fileHandler(child);
		return (LoggingProfile) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.logging.FileHandler object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.logging.FileHandler resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile fileHandler(String childKey) {
		fileHandler(childKey, null);
		return (LoggingProfile) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.logging.LogFile objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.logging.LogFile objects.
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile logFiles(
			List<org.wildfly.swarm.config.logging.LogFile> value) {
		this.subresources.logFiles.addAll(value);
		return (LoggingProfile) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.logging.LogFile object to the list of subresources
	 * @param value The org.wildfly.swarm.config.logging.LogFile to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile logFile(LogFile value) {
		this.subresources.logFiles.add(value);
		return (LoggingProfile) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.logging.LogFile object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.logging.LogFile resource
	 * @param config The org.wildfly.swarm.config.logging.LogFileConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile logFile(String childKey, LogFileConfigurator config) {
		org.wildfly.swarm.config.logging.LogFile child = new org.wildfly.swarm.config.logging.LogFile(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		logFile(child);
		return (LoggingProfile) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.logging.LogFile object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.logging.LogFile resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile logFile(String childKey) {
		logFile(childKey, null);
		return (LoggingProfile) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.logging.PatternFormatter objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.logging.PatternFormatter objects.
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile patternFormatters(
			List<org.wildfly.swarm.config.logging.PatternFormatter> value) {
		this.subresources.patternFormatters.addAll(value);
		return (LoggingProfile) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.logging.PatternFormatter object to the list of subresources
	 * @param value The org.wildfly.swarm.config.logging.PatternFormatter to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile patternFormatter(PatternFormatter value) {
		this.subresources.patternFormatters.add(value);
		return (LoggingProfile) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.logging.PatternFormatter object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.logging.PatternFormatter resource
	 * @param config The org.wildfly.swarm.config.logging.PatternFormatterConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile patternFormatter(String childKey,
			PatternFormatterConfigurator config) {
		org.wildfly.swarm.config.logging.PatternFormatter child = new org.wildfly.swarm.config.logging.PatternFormatter(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		patternFormatter(child);
		return (LoggingProfile) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.logging.PatternFormatter object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.logging.PatternFormatter resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile patternFormatter(String childKey) {
		patternFormatter(childKey, null);
		return (LoggingProfile) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.logging.SizeRotatingFileHandler objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.logging.SizeRotatingFileHandler objects.
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile sizeRotatingFileHandlers(
			List<org.wildfly.swarm.config.logging.SizeRotatingFileHandler> value) {
		this.subresources.sizeRotatingFileHandlers.addAll(value);
		return (LoggingProfile) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.logging.SizeRotatingFileHandler object to the list of subresources
	 * @param value The org.wildfly.swarm.config.logging.SizeRotatingFileHandler to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile sizeRotatingFileHandler(SizeRotatingFileHandler value) {
		this.subresources.sizeRotatingFileHandlers.add(value);
		return (LoggingProfile) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.logging.SizeRotatingFileHandler object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.logging.SizeRotatingFileHandler resource
	 * @param config The org.wildfly.swarm.config.logging.SizeRotatingFileHandlerConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile sizeRotatingFileHandler(String childKey,
			SizeRotatingFileHandlerConfigurator config) {
		org.wildfly.swarm.config.logging.SizeRotatingFileHandler child = new org.wildfly.swarm.config.logging.SizeRotatingFileHandler(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		sizeRotatingFileHandler(child);
		return (LoggingProfile) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.logging.SizeRotatingFileHandler object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.logging.SizeRotatingFileHandler resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile sizeRotatingFileHandler(String childKey) {
		sizeRotatingFileHandler(childKey, null);
		return (LoggingProfile) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.logging.SyslogHandler objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.logging.SyslogHandler objects.
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile syslogHandlers(
			List<org.wildfly.swarm.config.logging.SyslogHandler> value) {
		this.subresources.syslogHandlers.addAll(value);
		return (LoggingProfile) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.logging.SyslogHandler object to the list of subresources
	 * @param value The org.wildfly.swarm.config.logging.SyslogHandler to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile syslogHandler(SyslogHandler value) {
		this.subresources.syslogHandlers.add(value);
		return (LoggingProfile) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.logging.SyslogHandler object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.logging.SyslogHandler resource
	 * @param config The org.wildfly.swarm.config.logging.SyslogHandlerConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile syslogHandler(String childKey,
			SyslogHandlerConfigurator config) {
		org.wildfly.swarm.config.logging.SyslogHandler child = new org.wildfly.swarm.config.logging.SyslogHandler(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		syslogHandler(child);
		return (LoggingProfile) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.logging.SyslogHandler object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.logging.SyslogHandler resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile syslogHandler(String childKey) {
		syslogHandler(childKey, null);
		return (LoggingProfile) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.logging.CustomHandler objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.logging.CustomHandler objects.
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile customHandlers(
			List<org.wildfly.swarm.config.logging.CustomHandler> value) {
		this.subresources.customHandlers.addAll(value);
		return (LoggingProfile) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.logging.CustomHandler object to the list of subresources
	 * @param value The org.wildfly.swarm.config.logging.CustomHandler to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile customHandler(CustomHandler value) {
		this.subresources.customHandlers.add(value);
		return (LoggingProfile) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.logging.CustomHandler object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.logging.CustomHandler resource
	 * @param config The org.wildfly.swarm.config.logging.CustomHandlerConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile customHandler(String childKey,
			CustomHandlerConfigurator config) {
		org.wildfly.swarm.config.logging.CustomHandler child = new org.wildfly.swarm.config.logging.CustomHandler(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		customHandler(child);
		return (LoggingProfile) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.logging.CustomHandler object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.logging.CustomHandler resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile customHandler(String childKey) {
		customHandler(childKey, null);
		return (LoggingProfile) this;
	}

	/**
	 * Child mutators for LoggingProfile
	 */
	public class LoggingProfileResources {
		/**
		 * Defines a handler which writes to a file, rotating the log after a time period derived from the given suffix string, which should be in a format understood by java.text.SimpleDateFormat.
		 */
		private List<org.wildfly.swarm.config.logging.PeriodicRotatingFileHandler> periodicRotatingFileHandlers = new java.util.ArrayList<>();
		/**
		 * A custom formatter to be used with handlers. Note that most log records are formatted in the printf format. Formatters may require invocation of the org.jboss.logmanager.ExtLogRecord#getFormattedMessage() for the message to be properly formatted.
		 */
		private List<org.wildfly.swarm.config.logging.CustomFormatter> customFormatters = new java.util.ArrayList<>();
		/**
		 * Defines a handler which writes to a file, rotating the log after a time period derived from the given suffix string or after the size of the file grows beyond a certain point and keeping a fixed number of backups. The suffix should be in a format understood by the java.text.SimpleDateFormat. Any backups rotated by the suffix will not be purged during a size rotation.
		 */
		private List<org.wildfly.swarm.config.logging.PeriodicSizeRotatingFileHandler> periodicSizeRotatingFileHandlers = new java.util.ArrayList<>();
		/**
		 * Defines a handler which writes to the console.
		 */
		private List<org.wildfly.swarm.config.logging.ConsoleHandler> consoleHandlers = new java.util.ArrayList<>();
		/**
		 * Defines a logger category.
		 */
		private List<org.wildfly.swarm.config.logging.Logger> loggers = new java.util.ArrayList<>();
		/**
		 * Defines a handler which writes to the sub-handlers in an asynchronous thread. Used for handlers which introduce a substantial amount of lag.
		 */
		private List<org.wildfly.swarm.config.logging.AsyncHandler> asyncHandlers = new java.util.ArrayList<>();
		/**
		 * Defines a handler which writes to a file.
		 */
		private List<org.wildfly.swarm.config.logging.FileHandler> fileHandlers = new java.util.ArrayList<>();
		/**
		 * Log files that are available to be read.
		 */
		private List<org.wildfly.swarm.config.logging.LogFile> logFiles = new java.util.ArrayList<>();
		/**
		 * A pattern formatter to be used with handlers.
		 */
		private List<org.wildfly.swarm.config.logging.PatternFormatter> patternFormatters = new java.util.ArrayList<>();
		/**
		 * Defines a handler which writes to a file, rotating the log after the size of the file grows beyond a certain point and keeping a fixed number of backups.
		 */
		private List<org.wildfly.swarm.config.logging.SizeRotatingFileHandler> sizeRotatingFileHandlers = new java.util.ArrayList<>();
		/**
		 * Defines a syslog handler.
		 */
		private List<org.wildfly.swarm.config.logging.SyslogHandler> syslogHandlers = new java.util.ArrayList<>();
		/**
		 * Defines a custom logging handler. The custom handler must extend java.util.logging.Handler.
		 */
		private List<org.wildfly.swarm.config.logging.CustomHandler> customHandlers = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.logging.PeriodicRotatingFileHandler resources
		 * @return the list of resources
		 */
		@Subresource
		public List<PeriodicRotatingFileHandler> periodicRotatingFileHandlers() {
			return this.periodicRotatingFileHandlers;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.logging.CustomFormatter resources
		 * @return the list of resources
		 */
		@Subresource
		public List<CustomFormatter> customFormatters() {
			return this.customFormatters;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.logging.PeriodicSizeRotatingFileHandler resources
		 * @return the list of resources
		 */
		@Subresource
		public List<PeriodicSizeRotatingFileHandler> periodicSizeRotatingFileHandlers() {
			return this.periodicSizeRotatingFileHandlers;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.logging.ConsoleHandler resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ConsoleHandler> consoleHandlers() {
			return this.consoleHandlers;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.logging.Logger resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Logger> loggers() {
			return this.loggers;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.logging.AsyncHandler resources
		 * @return the list of resources
		 */
		@Subresource
		public List<AsyncHandler> asyncHandlers() {
			return this.asyncHandlers;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.logging.FileHandler resources
		 * @return the list of resources
		 */
		@Subresource
		public List<FileHandler> fileHandlers() {
			return this.fileHandlers;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.logging.LogFile resources
		 * @return the list of resources
		 */
		@Subresource
		public List<LogFile> logFiles() {
			return this.logFiles;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.logging.PatternFormatter resources
		 * @return the list of resources
		 */
		@Subresource
		public List<PatternFormatter> patternFormatters() {
			return this.patternFormatters;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.logging.SizeRotatingFileHandler resources
		 * @return the list of resources
		 */
		@Subresource
		public List<SizeRotatingFileHandler> sizeRotatingFileHandlers() {
			return this.sizeRotatingFileHandlers;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.logging.SyslogHandler resources
		 * @return the list of resources
		 */
		@Subresource
		public List<SyslogHandler> syslogHandlers() {
			return this.syslogHandlers;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.logging.CustomHandler resources
		 * @return the list of resources
		 */
		@Subresource
		public List<CustomHandler> customHandlers() {
			return this.customHandlers;
		}
	}

	/**
	 * Defines the root logger for this log context.
	 */
	@Subresource
	public RootLogger rootLogger() {
		return this.rootLogger;
	}

	/**
	 * Defines the root logger for this log context.
	 */
	@SuppressWarnings("unchecked")
	public LoggingProfile rootLogger(RootLogger value) {
		this.rootLogger = value;
		return (LoggingProfile) this;
	}
}