package org.wildfly.swarm.config.mail.mail_session;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * Mail session server
 */
@ResourceType("custom")
public class Custom<T extends Custom> {

	private String key;
	private String outboundSocketBindingRef;
	private String password;
	private Map properties;
	private Boolean ssl;
	private Boolean tls;
	private String username;

	public Custom(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Outbound Socket binding to mail server
	 */
	@ModelNodeBinding(detypedName = "outbound-socket-binding-ref")
	public String outboundSocketBindingRef() {
		return this.outboundSocketBindingRef;
	}

	/**
	 * Outbound Socket binding to mail server
	 */
	@SuppressWarnings("unchecked")
	public Custom outboundSocketBindingRef(String value) {
		this.outboundSocketBindingRef = value;
		return (Custom) this;
	}

	/**
	 * Password to authenticate on server
	 */
	@ModelNodeBinding(detypedName = "password")
	public String password() {
		return this.password;
	}

	/**
	 * Password to authenticate on server
	 */
	@SuppressWarnings("unchecked")
	public Custom password(String value) {
		this.password = value;
		return (Custom) this;
	}

	/**
	 * JavaMail properties
	 */
	@ModelNodeBinding(detypedName = "properties")
	public Map properties() {
		return this.properties;
	}

	/**
	 * JavaMail properties
	 */
	@SuppressWarnings("unchecked")
	public Custom properties(Map value) {
		this.properties = value;
		return (Custom) this;
	}

	/**
	 * Does server require SSL?
	 */
	@ModelNodeBinding(detypedName = "ssl")
	public Boolean ssl() {
		return this.ssl;
	}

	/**
	 * Does server require SSL?
	 */
	@SuppressWarnings("unchecked")
	public Custom ssl(Boolean value) {
		this.ssl = value;
		return (Custom) this;
	}

	/**
	 * Does server require TLS?
	 */
	@ModelNodeBinding(detypedName = "tls")
	public Boolean tls() {
		return this.tls;
	}

	/**
	 * Does server require TLS?
	 */
	@SuppressWarnings("unchecked")
	public Custom tls(Boolean value) {
		this.tls = value;
		return (Custom) this;
	}

	/**
	 * Username to authenticate on server
	 */
	@ModelNodeBinding(detypedName = "username")
	public String username() {
		return this.username;
	}

	/**
	 * Username to authenticate on server
	 */
	@SuppressWarnings("unchecked")
	public Custom username(String value) {
		this.username = value;
		return (Custom) this;
	}
}