package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
/**
 * A runtime-only resource representing a ActiveMQ "address". Zero or more queues can be bound to a single address. When a message is routed, it is routed to the set of queues bound to the message's address.
 */
@ResourceType("core-address")
public class CoreAddress<T extends CoreAddress> {

	private String key;
	private List<String> bindingNames;
	private Long numberOfBytesPerPage;
	private Integer numberOfPages;
	private List<String> queueNames;
	private CoreAddressResources subresources = new CoreAddressResources();

	public CoreAddress(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The names of all bindings (both queues and diverts) bound to this address.
	 */
	@ModelNodeBinding(detypedName = "binding-names")
	public List<String> bindingNames() {
		return this.bindingNames;
	}

	/**
	 * The names of all bindings (both queues and diverts) bound to this address.
	 */
	@SuppressWarnings("unchecked")
	public CoreAddress bindingNames(List<String> value) {
		this.bindingNames = value;
		return (CoreAddress) this;
	}

	/**
	 * The number of bytes used by each page for this address.
	 */
	@ModelNodeBinding(detypedName = "number-of-bytes-per-page")
	public Long numberOfBytesPerPage() {
		return this.numberOfBytesPerPage;
	}

	/**
	 * The number of bytes used by each page for this address.
	 */
	@SuppressWarnings("unchecked")
	public CoreAddress numberOfBytesPerPage(Long value) {
		this.numberOfBytesPerPage = value;
		return (CoreAddress) this;
	}

	/**
	 * The number of pages used by this address.
	 */
	@ModelNodeBinding(detypedName = "number-of-pages")
	public Integer numberOfPages() {
		return this.numberOfPages;
	}

	/**
	 * The number of pages used by this address.
	 */
	@SuppressWarnings("unchecked")
	public CoreAddress numberOfPages(Integer value) {
		this.numberOfPages = value;
		return (CoreAddress) this;
	}

	/**
	 * The names of the queues associated with the address.
	 */
	@ModelNodeBinding(detypedName = "queue-names")
	public List<String> queueNames() {
		return this.queueNames;
	}

	/**
	 * The names of the queues associated with the address.
	 */
	@SuppressWarnings("unchecked")
	public CoreAddress queueNames(List<String> value) {
		this.queueNames = value;
		return (CoreAddress) this;
	}

	public CoreAddressResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.Role objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.Role objects.
	 */
	@SuppressWarnings("unchecked")
	public CoreAddress roles(
			List<org.wildfly.swarm.config.messaging_activemq.server.Role> value) {
		this.subresources.roles.addAll(value);
		return (CoreAddress) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.Role object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.Role to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public CoreAddress role(Role value) {
		this.subresources.roles.add(value);
		return (CoreAddress) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.Role object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.Role resource
	 * @param config The org.wildfly.swarm.config.messaging_activemq.server.RoleConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public CoreAddress role(String childKey, RoleConfigurator config) {
		org.wildfly.swarm.config.messaging_activemq.server.Role child = new org.wildfly.swarm.config.messaging_activemq.server.Role(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		role(child);
		return (CoreAddress) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.Role object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.Role resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public CoreAddress role(String childKey) {
		role(childKey, null);
		return (CoreAddress) this;
	}

	/**
	 * Child mutators for CoreAddress
	 */
	public class CoreAddressResources {
		/**
		 * A security role.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.Role> roles = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.Role resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Role> roles() {
			return this.roles;
		}
	}
}