package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * Multicast group to listen to receive broadcast from other servers announcing their connectors.
 */
@ResourceType("discovery-group")
public class DiscoveryGroup<T extends DiscoveryGroup> {

	private String key;
	private Long initialWaitTimeout;
	private String jgroupsChannel;
	private String jgroupsStack;
	private Long refreshTimeout;
	private String socketBinding;

	public DiscoveryGroup(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Period, in ms, to wait for an initial broadcast to give us at least one node in the cluster.
	 */
	@ModelNodeBinding(detypedName = "initial-wait-timeout")
	public Long initialWaitTimeout() {
		return this.initialWaitTimeout;
	}

	/**
	 * Period, in ms, to wait for an initial broadcast to give us at least one node in the cluster.
	 */
	@SuppressWarnings("unchecked")
	public DiscoveryGroup initialWaitTimeout(Long value) {
		this.initialWaitTimeout = value;
		return (DiscoveryGroup) this;
	}

	/**
	 * The name used by a JGroups channel to join a cluster.
	 */
	@ModelNodeBinding(detypedName = "jgroups-channel")
	public String jgroupsChannel() {
		return this.jgroupsChannel;
	}

	/**
	 * The name used by a JGroups channel to join a cluster.
	 */
	@SuppressWarnings("unchecked")
	public DiscoveryGroup jgroupsChannel(String value) {
		this.jgroupsChannel = value;
		return (DiscoveryGroup) this;
	}

	/**
	 * The name of a stack defined in the org.jboss.as.clustering.jgroups subsystem that is used to form a cluster.
	 */
	@ModelNodeBinding(detypedName = "jgroups-stack")
	public String jgroupsStack() {
		return this.jgroupsStack;
	}

	/**
	 * The name of a stack defined in the org.jboss.as.clustering.jgroups subsystem that is used to form a cluster.
	 */
	@SuppressWarnings("unchecked")
	public DiscoveryGroup jgroupsStack(String value) {
		this.jgroupsStack = value;
		return (DiscoveryGroup) this;
	}

	/**
	 * Period the discovery group waits after receiving the last broadcast from a particular server before removing that server's connector pair entry from its list.
	 */
	@ModelNodeBinding(detypedName = "refresh-timeout")
	public Long refreshTimeout() {
		return this.refreshTimeout;
	}

	/**
	 * Period the discovery group waits after receiving the last broadcast from a particular server before removing that server's connector pair entry from its list.
	 */
	@SuppressWarnings("unchecked")
	public DiscoveryGroup refreshTimeout(Long value) {
		this.refreshTimeout = value;
		return (DiscoveryGroup) this;
	}

	/**
	 * The discovery group socket binding.
	 */
	@ModelNodeBinding(detypedName = "socket-binding")
	public String socketBinding() {
		return this.socketBinding;
	}

	/**
	 * The discovery group socket binding.
	 */
	@SuppressWarnings("unchecked")
	public DiscoveryGroup socketBinding(String value) {
		this.socketBinding = value;
		return (DiscoveryGroup) this;
	}
}