package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
/**
 * Defines a JMS queue.
 */
@ResourceType("jms-queue")
public class JmsQueue<T extends JmsQueue> {

	private String key;
	private Integer consumerCount;
	private String deadLetterAddress;
	private Integer deliveringCount;
	private Boolean durable;
	private List<String> entries;
	private String expiryAddress;
	private List<String> legacyEntries;
	private Long messageCount;
	private Long messagesAdded;
	private Boolean paused;
	private String queueAddress;
	private Long scheduledCount;
	private String selector;
	private Boolean temporary;

	public JmsQueue(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The number of consumers consuming messages from this queue.
	 */
	@ModelNodeBinding(detypedName = "consumer-count")
	public Integer consumerCount() {
		return this.consumerCount;
	}

	/**
	 * The number of consumers consuming messages from this queue.
	 */
	@SuppressWarnings("unchecked")
	public JmsQueue consumerCount(Integer value) {
		this.consumerCount = value;
		return (JmsQueue) this;
	}

	/**
	 * The address to send dead messages to.
	 */
	@ModelNodeBinding(detypedName = "dead-letter-address")
	public String deadLetterAddress() {
		return this.deadLetterAddress;
	}

	/**
	 * The address to send dead messages to.
	 */
	@SuppressWarnings("unchecked")
	public JmsQueue deadLetterAddress(String value) {
		this.deadLetterAddress = value;
		return (JmsQueue) this;
	}

	/**
	 * The number of messages that this queue is currently delivering to its consumers.
	 */
	@ModelNodeBinding(detypedName = "delivering-count")
	public Integer deliveringCount() {
		return this.deliveringCount;
	}

	/**
	 * The number of messages that this queue is currently delivering to its consumers.
	 */
	@SuppressWarnings("unchecked")
	public JmsQueue deliveringCount(Integer value) {
		this.deliveringCount = value;
		return (JmsQueue) this;
	}

	/**
	 * Whether the queue is durable or not.
	 */
	@ModelNodeBinding(detypedName = "durable")
	public Boolean durable() {
		return this.durable;
	}

	/**
	 * Whether the queue is durable or not.
	 */
	@SuppressWarnings("unchecked")
	public JmsQueue durable(Boolean value) {
		this.durable = value;
		return (JmsQueue) this;
	}

	/**
	 * The jndi names the queue will be bound to.
	 */
	@ModelNodeBinding(detypedName = "entries")
	public List<String> entries() {
		return this.entries;
	}

	/**
	 * The jndi names the queue will be bound to.
	 */
	@SuppressWarnings("unchecked")
	public JmsQueue entries(List<String> value) {
		this.entries = value;
		return (JmsQueue) this;
	}

	/**
	 * The address to send expired messages to.
	 */
	@ModelNodeBinding(detypedName = "expiry-address")
	public String expiryAddress() {
		return this.expiryAddress;
	}

	/**
	 * The address to send expired messages to.
	 */
	@SuppressWarnings("unchecked")
	public JmsQueue expiryAddress(String value) {
		this.expiryAddress = value;
		return (JmsQueue) this;
	}

	/**
	 * The jndi names the queue will be bound to.
	 */
	@ModelNodeBinding(detypedName = "legacy-entries")
	public List<String> legacyEntries() {
		return this.legacyEntries;
	}

	/**
	 * The jndi names the queue will be bound to.
	 */
	@SuppressWarnings("unchecked")
	public JmsQueue legacyEntries(List<String> value) {
		this.legacyEntries = value;
		return (JmsQueue) this;
	}

	/**
	 * The number of messages currently in this queue.
	 */
	@ModelNodeBinding(detypedName = "message-count")
	public Long messageCount() {
		return this.messageCount;
	}

	/**
	 * The number of messages currently in this queue.
	 */
	@SuppressWarnings("unchecked")
	public JmsQueue messageCount(Long value) {
		this.messageCount = value;
		return (JmsQueue) this;
	}

	/**
	 * The number of messages added to this queue since it was created.
	 */
	@ModelNodeBinding(detypedName = "messages-added")
	public Long messagesAdded() {
		return this.messagesAdded;
	}

	/**
	 * The number of messages added to this queue since it was created.
	 */
	@SuppressWarnings("unchecked")
	public JmsQueue messagesAdded(Long value) {
		this.messagesAdded = value;
		return (JmsQueue) this;
	}

	/**
	 * Whether the queue is paused.
	 */
	@ModelNodeBinding(detypedName = "paused")
	public Boolean paused() {
		return this.paused;
	}

	/**
	 * Whether the queue is paused.
	 */
	@SuppressWarnings("unchecked")
	public JmsQueue paused(Boolean value) {
		this.paused = value;
		return (JmsQueue) this;
	}

	/**
	 * The queue address defines what address is used for routing messages.
	 */
	@ModelNodeBinding(detypedName = "queue-address")
	public String queueAddress() {
		return this.queueAddress;
	}

	/**
	 * The queue address defines what address is used for routing messages.
	 */
	@SuppressWarnings("unchecked")
	public JmsQueue queueAddress(String value) {
		this.queueAddress = value;
		return (JmsQueue) this;
	}

	/**
	 * The number of scheduled messages in this queue.
	 */
	@ModelNodeBinding(detypedName = "scheduled-count")
	public Long scheduledCount() {
		return this.scheduledCount;
	}

	/**
	 * The number of scheduled messages in this queue.
	 */
	@SuppressWarnings("unchecked")
	public JmsQueue scheduledCount(Long value) {
		this.scheduledCount = value;
		return (JmsQueue) this;
	}

	/**
	 * The queue selector.
	 */
	@ModelNodeBinding(detypedName = "selector")
	public String selector() {
		return this.selector;
	}

	/**
	 * The queue selector.
	 */
	@SuppressWarnings("unchecked")
	public JmsQueue selector(String value) {
		this.selector = value;
		return (JmsQueue) this;
	}

	/**
	 * Whether the queue is temporary.
	 */
	@ModelNodeBinding(detypedName = "temporary")
	public Boolean temporary() {
		return this.temporary;
	}

	/**
	 * Whether the queue is temporary.
	 */
	@SuppressWarnings("unchecked")
	public JmsQueue temporary(Boolean value) {
		this.temporary = value;
		return (JmsQueue) this;
	}
}