package org.wildfly.swarm.config.messaging_activemq.server.ha_policy.shared_store_colocated;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
 */
@ResourceType("configuration")
@Implicit
public class MasterConfiguration<T extends MasterConfiguration> {

	private String key;
	private Long failbackDelay;
	private Boolean failoverOnServerShutdown;

	public MasterConfiguration() {
		this.key = "master";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * delay to wait before failback occurs on (live's) restart
	 */
	@ModelNodeBinding(detypedName = "failback-delay")
	public Long failbackDelay() {
		return this.failbackDelay;
	}

	/**
	 * delay to wait before failback occurs on (live's) restart
	 */
	@SuppressWarnings("unchecked")
	public MasterConfiguration failbackDelay(Long value) {
		this.failbackDelay = value;
		return (MasterConfiguration) this;
	}

	/**
	 * Whether the server must failover when it is normally shutdown.
	 */
	@ModelNodeBinding(detypedName = "failover-on-server-shutdown")
	public Boolean failoverOnServerShutdown() {
		return this.failoverOnServerShutdown;
	}

	/**
	 * Whether the server must failover when it is normally shutdown.
	 */
	@SuppressWarnings("unchecked")
	public MasterConfiguration failoverOnServerShutdown(Boolean value) {
		this.failoverOnServerShutdown = value;
		return (MasterConfiguration) this;
	}
}