package org.wildfly.swarm.config.security.security_domain;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.security.security_domain.acl.AclModule;
import org.wildfly.swarm.config.security.security_domain.acl.AclModuleConfigurator;
/**
 * Access control list configuration. Configures a list of ACL modules to be used.
 */
@ResourceType("acl")
@Implicit
public class ClassicAcl<T extends ClassicAcl> {

	private String key;
	private ClassicAclResources subresources = new ClassicAclResources();

	public ClassicAcl() {
		this.key = "classic";
	}

	public String getKey() {
		return this.key;
	}

	public ClassicAclResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.security.security_domain.acl.AclModule objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.security.security_domain.acl.AclModule objects.
	 */
	@SuppressWarnings("unchecked")
	public ClassicAcl aclModules(
			List<org.wildfly.swarm.config.security.security_domain.acl.AclModule> value) {
		this.subresources.aclModules.addAll(value);
		return (ClassicAcl) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.security.security_domain.acl.AclModule object to the list of subresources
	 * @param value The org.wildfly.swarm.config.security.security_domain.acl.AclModule to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public ClassicAcl aclModule(AclModule value) {
		this.subresources.aclModules.add(value);
		return (ClassicAcl) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.security.security_domain.acl.AclModule object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.security.security_domain.acl.AclModule resource
	 * @param config The org.wildfly.swarm.config.security.security_domain.acl.AclModuleConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public ClassicAcl aclModule(String childKey, AclModuleConfigurator config) {
		org.wildfly.swarm.config.security.security_domain.acl.AclModule child = new org.wildfly.swarm.config.security.security_domain.acl.AclModule(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		aclModule(child);
		return (ClassicAcl) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.security.security_domain.acl.AclModule object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.security.security_domain.acl.AclModule resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public ClassicAcl aclModule(String childKey) {
		aclModule(childKey, null);
		return (ClassicAcl) this;
	}

	/**
	 * Child mutators for ClassicAcl
	 */
	public class ClassicAclResources {
		/**
		 * List of authentication modules
		 */
		private List<org.wildfly.swarm.config.security.security_domain.acl.AclModule> aclModules = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.security.security_domain.acl.AclModule resources
		 * @return the list of resources
		 */
		@Subresource
		public List<AclModule> aclModules() {
			return this.aclModules;
		}
	}
}