package org.wildfly.swarm.config.security.security_domain;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.security.security_domain.authorization.PolicyModule;
import org.wildfly.swarm.config.security.security_domain.authorization.PolicyModuleConfigurator;
/**
 * Authorization configuration. Configures a list of authorization policy modules to be used.
 */
@ResourceType("authorization")
@Implicit
public class ClassicAuthorization<T extends ClassicAuthorization> {

	private String key;
	private ClassicAuthorizationResources subresources = new ClassicAuthorizationResources();

	public ClassicAuthorization() {
		this.key = "classic";
	}

	public String getKey() {
		return this.key;
	}

	public ClassicAuthorizationResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.security.security_domain.authorization.PolicyModule objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.security.security_domain.authorization.PolicyModule objects.
	 */
	@SuppressWarnings("unchecked")
	public ClassicAuthorization policyModules(
			List<org.wildfly.swarm.config.security.security_domain.authorization.PolicyModule> value) {
		this.subresources.policyModules.addAll(value);
		return (ClassicAuthorization) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.security.security_domain.authorization.PolicyModule object to the list of subresources
	 * @param value The org.wildfly.swarm.config.security.security_domain.authorization.PolicyModule to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public ClassicAuthorization policyModule(PolicyModule value) {
		this.subresources.policyModules.add(value);
		return (ClassicAuthorization) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.security.security_domain.authorization.PolicyModule object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.security.security_domain.authorization.PolicyModule resource
	 * @param config The org.wildfly.swarm.config.security.security_domain.authorization.PolicyModuleConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public ClassicAuthorization policyModule(String childKey,
			PolicyModuleConfigurator config) {
		org.wildfly.swarm.config.security.security_domain.authorization.PolicyModule child = new org.wildfly.swarm.config.security.security_domain.authorization.PolicyModule(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		policyModule(child);
		return (ClassicAuthorization) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.security.security_domain.authorization.PolicyModule object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.security.security_domain.authorization.PolicyModule resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public ClassicAuthorization policyModule(String childKey) {
		policyModule(childKey, null);
		return (ClassicAuthorization) this;
	}

	/**
	 * Child mutators for ClassicAuthorization
	 */
	public class ClassicAuthorizationResources {
		/**
		 * List of authentication modules
		 */
		private List<org.wildfly.swarm.config.security.security_domain.authorization.PolicyModule> policyModules = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.security.security_domain.authorization.PolicyModule resources
		 * @return the list of resources
		 */
		@Subresource
		public List<PolicyModule> policyModules() {
			return this.policyModules;
		}
	}
}