package org.wildfly.swarm.config.security.security_domain;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.security.security_domain.identity_trust.TrustModule;
import org.wildfly.swarm.config.security.security_domain.identity_trust.TrustModuleConfigurator;
/**
 * Identity trust configuration. Configures a list of trust modules to be used.
 */
@ResourceType("identity-trust")
@Implicit
public class ClassicIdentityTrust<T extends ClassicIdentityTrust> {

	private String key;
	private ClassicIdentityTrustResources subresources = new ClassicIdentityTrustResources();

	public ClassicIdentityTrust() {
		this.key = "classic";
	}

	public String getKey() {
		return this.key;
	}

	public ClassicIdentityTrustResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.security.security_domain.identity_trust.TrustModule objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.security.security_domain.identity_trust.TrustModule objects.
	 */
	@SuppressWarnings("unchecked")
	public ClassicIdentityTrust trustModules(
			List<org.wildfly.swarm.config.security.security_domain.identity_trust.TrustModule> value) {
		this.subresources.trustModules.addAll(value);
		return (ClassicIdentityTrust) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.security.security_domain.identity_trust.TrustModule object to the list of subresources
	 * @param value The org.wildfly.swarm.config.security.security_domain.identity_trust.TrustModule to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public ClassicIdentityTrust trustModule(TrustModule value) {
		this.subresources.trustModules.add(value);
		return (ClassicIdentityTrust) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.security.security_domain.identity_trust.TrustModule object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.security.security_domain.identity_trust.TrustModule resource
	 * @param config The org.wildfly.swarm.config.security.security_domain.identity_trust.TrustModuleConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public ClassicIdentityTrust trustModule(String childKey,
			TrustModuleConfigurator config) {
		org.wildfly.swarm.config.security.security_domain.identity_trust.TrustModule child = new org.wildfly.swarm.config.security.security_domain.identity_trust.TrustModule(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		trustModule(child);
		return (ClassicIdentityTrust) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.security.security_domain.identity_trust.TrustModule object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.security.security_domain.identity_trust.TrustModule resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public ClassicIdentityTrust trustModule(String childKey) {
		trustModule(childKey, null);
		return (ClassicIdentityTrust) this;
	}

	/**
	 * Child mutators for ClassicIdentityTrust
	 */
	public class ClassicIdentityTrustResources {
		/**
		 * List of authentication modules
		 */
		private List<org.wildfly.swarm.config.security.security_domain.identity_trust.TrustModule> trustModules = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.security.security_domain.identity_trust.TrustModule resources
		 * @return the list of resources
		 */
		@Subresource
		public List<TrustModule> trustModules() {
			return this.trustModules;
		}
	}
}