package org.wildfly.swarm.config.transactions;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * a CMR resource (i.e. a local resource that can reliably participate in an XA transaction)
 */
@ResourceType("commit-markable-resource")
public class CommitMarkableResource<T extends CommitMarkableResource> {

	private String key;
	private Integer batchSize;
	private Boolean immediateCleanup;
	private String jndiName;
	private String name;

	public CommitMarkableResource(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Batch size for this CMR resource
	 */
	@ModelNodeBinding(detypedName = "batch-size")
	public Integer batchSize() {
		return this.batchSize;
	}

	/**
	 * Batch size for this CMR resource
	 */
	@SuppressWarnings("unchecked")
	public CommitMarkableResource batchSize(Integer value) {
		this.batchSize = value;
		return (CommitMarkableResource) this;
	}

	/**
	 * Immediate cleanup associated to this CMR resource
	 */
	@ModelNodeBinding(detypedName = "immediate-cleanup")
	public Boolean immediateCleanup() {
		return this.immediateCleanup;
	}

	/**
	 * Immediate cleanup associated to this CMR resource
	 */
	@SuppressWarnings("unchecked")
	public CommitMarkableResource immediateCleanup(Boolean value) {
		this.immediateCleanup = value;
		return (CommitMarkableResource) this;
	}

	/**
	 * JNDi name of this CMR resource
	 */
	@ModelNodeBinding(detypedName = "jndi-name")
	public String jndiName() {
		return this.jndiName;
	}

	/**
	 * JNDi name of this CMR resource
	 */
	@SuppressWarnings("unchecked")
	public CommitMarkableResource jndiName(String value) {
		this.jndiName = value;
		return (CommitMarkableResource) this;
	}

	/**
	 * table name for storing XIDs
	 */
	@ModelNodeBinding(detypedName = "name")
	public String name() {
		return this.name;
	}

	/**
	 * table name for storing XIDs
	 */
	@SuppressWarnings("unchecked")
	public CommitMarkableResource name(String value) {
		this.name = value;
		return (CommitMarkableResource) this;
	}
}