package org.wildfly.swarm.config.undertow;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.configuration.ReverseProxy;
import org.wildfly.swarm.config.undertow.configuration.ReverseProxyConfigurator;
import org.wildfly.swarm.config.undertow.configuration.File;
import org.wildfly.swarm.config.undertow.configuration.FileConfigurator;
/**
 * Undertow handlers
 */
@ResourceType("configuration")
@Implicit
public class HandlerConfiguration<T extends HandlerConfiguration> {

	private String key;
	private HandlerConfigurationResources subresources = new HandlerConfigurationResources();

	public HandlerConfiguration() {
		this.key = "handler";
	}

	public String getKey() {
		return this.key;
	}

	public HandlerConfigurationResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.undertow.configuration.ReverseProxy objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.undertow.configuration.ReverseProxy objects.
	 */
	@SuppressWarnings("unchecked")
	public HandlerConfiguration reverseProxys(
			List<org.wildfly.swarm.config.undertow.configuration.ReverseProxy> value) {
		this.subresources.reverseProxys.addAll(value);
		return (HandlerConfiguration) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.undertow.configuration.ReverseProxy object to the list of subresources
	 * @param value The org.wildfly.swarm.config.undertow.configuration.ReverseProxy to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public HandlerConfiguration reverseProxy(ReverseProxy value) {
		this.subresources.reverseProxys.add(value);
		return (HandlerConfiguration) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.undertow.configuration.ReverseProxy object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.undertow.configuration.ReverseProxy resource
	 * @param config The org.wildfly.swarm.config.undertow.configuration.ReverseProxyConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public HandlerConfiguration reverseProxy(String childKey,
			ReverseProxyConfigurator config) {
		org.wildfly.swarm.config.undertow.configuration.ReverseProxy child = new org.wildfly.swarm.config.undertow.configuration.ReverseProxy(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		reverseProxy(child);
		return (HandlerConfiguration) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.undertow.configuration.ReverseProxy object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.undertow.configuration.ReverseProxy resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public HandlerConfiguration reverseProxy(String childKey) {
		reverseProxy(childKey, null);
		return (HandlerConfiguration) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.undertow.configuration.File objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.undertow.configuration.File objects.
	 */
	@SuppressWarnings("unchecked")
	public HandlerConfiguration files(
			List<org.wildfly.swarm.config.undertow.configuration.File> value) {
		this.subresources.files.addAll(value);
		return (HandlerConfiguration) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.undertow.configuration.File object to the list of subresources
	 * @param value The org.wildfly.swarm.config.undertow.configuration.File to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public HandlerConfiguration file(File value) {
		this.subresources.files.add(value);
		return (HandlerConfiguration) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.undertow.configuration.File object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.undertow.configuration.File resource
	 * @param config The org.wildfly.swarm.config.undertow.configuration.FileConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public HandlerConfiguration file(String childKey, FileConfigurator config) {
		org.wildfly.swarm.config.undertow.configuration.File child = new org.wildfly.swarm.config.undertow.configuration.File(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		file(child);
		return (HandlerConfiguration) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.undertow.configuration.File object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.undertow.configuration.File resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public HandlerConfiguration file(String childKey) {
		file(childKey, null);
		return (HandlerConfiguration) this;
	}

	/**
	 * Child mutators for HandlerConfiguration
	 */
	public class HandlerConfigurationResources {
		/**
		 * A reverse proxy handler
		 */
		private List<org.wildfly.swarm.config.undertow.configuration.ReverseProxy> reverseProxys = new java.util.ArrayList<>();
		/**
		 * File handler
		 */
		private List<org.wildfly.swarm.config.undertow.configuration.File> files = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.undertow.configuration.ReverseProxy resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ReverseProxy> reverseProxys() {
			return this.reverseProxys;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.undertow.configuration.File resources
		 * @return the list of resources
		 */
		@Subresource
		public List<File> files() {
			return this.files;
		}
	}
}