package org.wildfly.swarm.config.undertow;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.server.Host;
import org.wildfly.swarm.config.undertow.server.HostConfigurator;
import org.wildfly.swarm.config.undertow.server.HttpListener;
import org.wildfly.swarm.config.undertow.server.HttpListenerConfigurator;
import org.wildfly.swarm.config.undertow.server.AjpListener;
import org.wildfly.swarm.config.undertow.server.AjpListenerConfigurator;
import org.wildfly.swarm.config.undertow.server.HttpsListener;
import org.wildfly.swarm.config.undertow.server.HttpsListenerConfigurator;
/**
 * A server
 */
@ResourceType("server")
public class Server<T extends Server> {

	private String key;
	private String defaultHost;
	private String servletContainer;
	private ServerResources subresources = new ServerResources();

	public Server(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The servers default virtual host
	 */
	@ModelNodeBinding(detypedName = "default-host")
	public String defaultHost() {
		return this.defaultHost;
	}

	/**
	 * The servers default virtual host
	 */
	@SuppressWarnings("unchecked")
	public Server defaultHost(String value) {
		this.defaultHost = value;
		return (Server) this;
	}

	/**
	 * The servers default servlet container
	 */
	@ModelNodeBinding(detypedName = "servlet-container")
	public String servletContainer() {
		return this.servletContainer;
	}

	/**
	 * The servers default servlet container
	 */
	@SuppressWarnings("unchecked")
	public Server servletContainer(String value) {
		this.servletContainer = value;
		return (Server) this;
	}

	public ServerResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.undertow.server.Host objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.undertow.server.Host objects.
	 */
	@SuppressWarnings("unchecked")
	public Server hosts(
			List<org.wildfly.swarm.config.undertow.server.Host> value) {
		this.subresources.hosts.addAll(value);
		return (Server) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.undertow.server.Host object to the list of subresources
	 * @param value The org.wildfly.swarm.config.undertow.server.Host to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Server host(Host value) {
		this.subresources.hosts.add(value);
		return (Server) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.undertow.server.Host object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.undertow.server.Host resource
	 * @param config The org.wildfly.swarm.config.undertow.server.HostConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Server host(String childKey, HostConfigurator config) {
		org.wildfly.swarm.config.undertow.server.Host child = new org.wildfly.swarm.config.undertow.server.Host(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		host(child);
		return (Server) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.undertow.server.Host object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.undertow.server.Host resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Server host(String childKey) {
		host(childKey, null);
		return (Server) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.undertow.server.HttpListener objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.undertow.server.HttpListener objects.
	 */
	@SuppressWarnings("unchecked")
	public Server httpListeners(
			List<org.wildfly.swarm.config.undertow.server.HttpListener> value) {
		this.subresources.httpListeners.addAll(value);
		return (Server) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.undertow.server.HttpListener object to the list of subresources
	 * @param value The org.wildfly.swarm.config.undertow.server.HttpListener to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Server httpListener(HttpListener value) {
		this.subresources.httpListeners.add(value);
		return (Server) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.undertow.server.HttpListener object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.undertow.server.HttpListener resource
	 * @param config The org.wildfly.swarm.config.undertow.server.HttpListenerConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Server httpListener(String childKey, HttpListenerConfigurator config) {
		org.wildfly.swarm.config.undertow.server.HttpListener child = new org.wildfly.swarm.config.undertow.server.HttpListener(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		httpListener(child);
		return (Server) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.undertow.server.HttpListener object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.undertow.server.HttpListener resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Server httpListener(String childKey) {
		httpListener(childKey, null);
		return (Server) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.undertow.server.AjpListener objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.undertow.server.AjpListener objects.
	 */
	@SuppressWarnings("unchecked")
	public Server ajpListeners(
			List<org.wildfly.swarm.config.undertow.server.AjpListener> value) {
		this.subresources.ajpListeners.addAll(value);
		return (Server) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.undertow.server.AjpListener object to the list of subresources
	 * @param value The org.wildfly.swarm.config.undertow.server.AjpListener to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Server ajpListener(AjpListener value) {
		this.subresources.ajpListeners.add(value);
		return (Server) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.undertow.server.AjpListener object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.undertow.server.AjpListener resource
	 * @param config The org.wildfly.swarm.config.undertow.server.AjpListenerConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Server ajpListener(String childKey, AjpListenerConfigurator config) {
		org.wildfly.swarm.config.undertow.server.AjpListener child = new org.wildfly.swarm.config.undertow.server.AjpListener(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		ajpListener(child);
		return (Server) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.undertow.server.AjpListener object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.undertow.server.AjpListener resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Server ajpListener(String childKey) {
		ajpListener(childKey, null);
		return (Server) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.undertow.server.HttpsListener objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.undertow.server.HttpsListener objects.
	 */
	@SuppressWarnings("unchecked")
	public Server httpsListeners(
			List<org.wildfly.swarm.config.undertow.server.HttpsListener> value) {
		this.subresources.httpsListeners.addAll(value);
		return (Server) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.undertow.server.HttpsListener object to the list of subresources
	 * @param value The org.wildfly.swarm.config.undertow.server.HttpsListener to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Server httpsListener(HttpsListener value) {
		this.subresources.httpsListeners.add(value);
		return (Server) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.undertow.server.HttpsListener object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.undertow.server.HttpsListener resource
	 * @param config The org.wildfly.swarm.config.undertow.server.HttpsListenerConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Server httpsListener(String childKey,
			HttpsListenerConfigurator config) {
		org.wildfly.swarm.config.undertow.server.HttpsListener child = new org.wildfly.swarm.config.undertow.server.HttpsListener(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		httpsListener(child);
		return (Server) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.undertow.server.HttpsListener object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.undertow.server.HttpsListener resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Server httpsListener(String childKey) {
		httpsListener(childKey, null);
		return (Server) this;
	}

	/**
	 * Child mutators for Server
	 */
	public class ServerResources {
		/**
		 * An Undertow host
		 */
		private List<org.wildfly.swarm.config.undertow.server.Host> hosts = new java.util.ArrayList<>();
		/**
		 * http listener
		 */
		private List<org.wildfly.swarm.config.undertow.server.HttpListener> httpListeners = new java.util.ArrayList<>();
		/**
		 * http listener
		 */
		private List<org.wildfly.swarm.config.undertow.server.AjpListener> ajpListeners = new java.util.ArrayList<>();
		/**
		 * http listener
		 */
		private List<org.wildfly.swarm.config.undertow.server.HttpsListener> httpsListeners = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.undertow.server.Host resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Host> hosts() {
			return this.hosts;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.undertow.server.HttpListener resources
		 * @return the list of resources
		 */
		@Subresource
		public List<HttpListener> httpListeners() {
			return this.httpListeners;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.undertow.server.AjpListener resources
		 * @return the list of resources
		 */
		@Subresource
		public List<AjpListener> ajpListeners() {
			return this.ajpListeners;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.undertow.server.HttpsListener resources
		 * @return the list of resources
		 */
		@Subresource
		public List<HttpsListener> httpsListeners() {
			return this.httpsListeners;
		}
	}
}