package org.wildfly.swarm.config.undertow.configuration;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
/**
 * File handler
 */
@ResourceType("file")
public class File<T extends File> {

	private String key;
	private Long cacheBufferSize;
	private Long cacheBuffers;
	private Boolean caseSensitive;
	private Boolean directoryListing;
	private Boolean followSymlink;
	private String path;
	private List<String> safeSymlinkPaths;

	public File(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Size of the buffers
	 */
	@ModelNodeBinding(detypedName = "cache-buffer-size")
	public Long cacheBufferSize() {
		return this.cacheBufferSize;
	}

	/**
	 * Size of the buffers
	 */
	@SuppressWarnings("unchecked")
	public File cacheBufferSize(Long value) {
		this.cacheBufferSize = value;
		return (File) this;
	}

	/**
	 * Number of buffers
	 */
	@ModelNodeBinding(detypedName = "cache-buffers")
	public Long cacheBuffers() {
		return this.cacheBuffers;
	}

	/**
	 * Number of buffers
	 */
	@SuppressWarnings("unchecked")
	public File cacheBuffers(Long value) {
		this.cacheBuffers = value;
		return (File) this;
	}

	/**
	 * Use case sensitive file handling
	 */
	@ModelNodeBinding(detypedName = "case-sensitive")
	public Boolean caseSensitive() {
		return this.caseSensitive;
	}

	/**
	 * Use case sensitive file handling
	 */
	@SuppressWarnings("unchecked")
	public File caseSensitive(Boolean value) {
		this.caseSensitive = value;
		return (File) this;
	}

	/**
	 * Enable directory listing?
	 */
	@ModelNodeBinding(detypedName = "directory-listing")
	public Boolean directoryListing() {
		return this.directoryListing;
	}

	/**
	 * Enable directory listing?
	 */
	@SuppressWarnings("unchecked")
	public File directoryListing(Boolean value) {
		this.directoryListing = value;
		return (File) this;
	}

	/**
	 * Enable following symbolic links
	 */
	@ModelNodeBinding(detypedName = "follow-symlink")
	public Boolean followSymlink() {
		return this.followSymlink;
	}

	/**
	 * Enable following symbolic links
	 */
	@SuppressWarnings("unchecked")
	public File followSymlink(Boolean value) {
		this.followSymlink = value;
		return (File) this;
	}

	/**
	 * Path on filesystem from where file handler will serve resources
	 */
	@ModelNodeBinding(detypedName = "path")
	public String path() {
		return this.path;
	}

	/**
	 * Path on filesystem from where file handler will serve resources
	 */
	@SuppressWarnings("unchecked")
	public File path(String value) {
		this.path = value;
		return (File) this;
	}

	/**
	 * Paths that are safe to be targets of symbolic links
	 */
	@ModelNodeBinding(detypedName = "safe-symlink-paths")
	public List<String> safeSymlinkPaths() {
		return this.safeSymlinkPaths;
	}

	/**
	 * Paths that are safe to be targets of symbolic links
	 */
	@SuppressWarnings("unchecked")
	public File safeSymlinkPaths(List<String> value) {
		this.safeSymlinkPaths = value;
		return (File) this;
	}
}