package org.wildfly.swarm.config.undertow.configuration;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * Response header filter allows you to add custom headers.
 */
@ResourceType("response-header")
public class ResponseHeader<T extends ResponseHeader> {

	private String key;
	private String headerName;
	private String headerValue;

	public ResponseHeader(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Header name
	 */
	@ModelNodeBinding(detypedName = "header-name")
	public String headerName() {
		return this.headerName;
	}

	/**
	 * Header name
	 */
	@SuppressWarnings("unchecked")
	public ResponseHeader headerName(String value) {
		this.headerName = value;
		return (ResponseHeader) this;
	}

	/**
	 * Value for header
	 */
	@ModelNodeBinding(detypedName = "header-value")
	public String headerValue() {
		return this.headerValue;
	}

	/**
	 * Value for header
	 */
	@SuppressWarnings("unchecked")
	public ResponseHeader headerValue(String value) {
		this.headerValue = value;
		return (ResponseHeader) this;
	}
}