package org.wildfly.swarm.config.undertow.configuration.reverse_proxy;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * A host that the reverse proxy will forward requests to
 */
@ResourceType("host")
public class Host<T extends Host> {

	private String key;
	private String instanceId;
	private String outboundSocketBinding;
	private String path;
	private String scheme;
	private String securityRealm;

	public Host(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The instance id (aka JVM route) that will be used to enable sticky sessions
	 */
	@ModelNodeBinding(detypedName = "instance-id")
	public String instanceId() {
		return this.instanceId;
	}

	/**
	 * The instance id (aka JVM route) that will be used to enable sticky sessions
	 */
	@SuppressWarnings("unchecked")
	public Host instanceId(String value) {
		this.instanceId = value;
		return (Host) this;
	}

	/**
	 * Outbound socket binding for this host
	 */
	@ModelNodeBinding(detypedName = "outbound-socket-binding")
	public String outboundSocketBinding() {
		return this.outboundSocketBinding;
	}

	/**
	 * Outbound socket binding for this host
	 */
	@SuppressWarnings("unchecked")
	public Host outboundSocketBinding(String value) {
		this.outboundSocketBinding = value;
		return (Host) this;
	}

	/**
	 * Optional path if host is using non root resource
	 */
	@ModelNodeBinding(detypedName = "path")
	public String path() {
		return this.path;
	}

	/**
	 * Optional path if host is using non root resource
	 */
	@SuppressWarnings("unchecked")
	public Host path(String value) {
		this.path = value;
		return (Host) this;
	}

	/**
	 * What kind of scheme is used
	 */
	@ModelNodeBinding(detypedName = "scheme")
	public String scheme() {
		return this.scheme;
	}

	/**
	 * What kind of scheme is used
	 */
	@SuppressWarnings("unchecked")
	public Host scheme(String value) {
		this.scheme = value;
		return (Host) this;
	}

	/**
	 * The security realm that provides the SSL configuration for the connection to the host
	 */
	@ModelNodeBinding(detypedName = "security-realm")
	public String securityRealm() {
		return this.securityRealm;
	}

	/**
	 * The security realm that provides the SSL configuration for the connection to the host
	 */
	@SuppressWarnings("unchecked")
	public Host securityRealm(String value) {
		this.securityRealm = value;
		return (Host) this;
	}
}