/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.io.BufferPool;
import org.wildfly.swarm.config.io.BufferPoolConfigurator;
import org.wildfly.swarm.config.io.Worker;
import org.wildfly.swarm.config.io.WorkerConfigurator;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;

@ResourceType(value="subsystem")
@Implicit
public class Io<T extends Io> {
    private String key = "io";
    private IoResources subresources = new IoResources();

    public String getKey() {
        return this.key;
    }

    public IoResources subresources() {
        return this.subresources;
    }

    public T workers(List<Worker> value) {
        this.subresources.workers.addAll(value);
        return (T)this;
    }

    public T worker(Worker value) {
        this.subresources.workers.add(value);
        return (T)this;
    }

    public T worker(String childKey, WorkerConfigurator config) {
        Worker child = new Worker(childKey);
        if (config != null) {
            config.configure(child);
        }
        this.worker(child);
        return (T)this;
    }

    public T worker(String childKey) {
        this.worker(childKey, null);
        return (T)this;
    }

    public T bufferPools(List<BufferPool> value) {
        this.subresources.bufferPools.addAll(value);
        return (T)this;
    }

    public T bufferPool(BufferPool value) {
        this.subresources.bufferPools.add(value);
        return (T)this;
    }

    public T bufferPool(String childKey, BufferPoolConfigurator config) {
        BufferPool child = new BufferPool(childKey);
        if (config != null) {
            config.configure(child);
        }
        this.bufferPool(child);
        return (T)this;
    }

    public T bufferPool(String childKey) {
        this.bufferPool(childKey, null);
        return (T)this;
    }

    public class IoResources {
        private List<Worker> workers = new ArrayList<Worker>();
        private List<BufferPool> bufferPools = new ArrayList<BufferPool>();

        @Subresource
        public List<Worker> workers() {
            return this.workers;
        }

        @Subresource
        public List<BufferPool> bufferPools() {
            return this.bufferPools;
        }
    }
}

