/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.undertow.configuration.mod_cluster;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.LoadBalancingGroup;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.LoadBalancingGroupConfigurator;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.Node;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.NodeConfigurator;

@ResourceType(value="balancer")
public class Balancer<T extends Balancer> {
    private String key;
    private Integer maxAttempts;
    private Boolean stickySession;
    private String stickySessionCookie;
    private Boolean stickySessionForce;
    private String stickySessionPath;
    private Boolean stickySessionRemove;
    private Integer waitWorker;
    private BalancerResources subresources = new BalancerResources();

    public Balancer(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    @ModelNodeBinding(detypedName="max-attempts")
    public Integer maxAttempts() {
        return this.maxAttempts;
    }

    public Balancer maxAttempts(Integer value) {
        this.maxAttempts = value;
        return this;
    }

    @ModelNodeBinding(detypedName="sticky-session")
    public Boolean stickySession() {
        return this.stickySession;
    }

    public Balancer stickySession(Boolean value) {
        this.stickySession = value;
        return this;
    }

    @ModelNodeBinding(detypedName="sticky-session-cookie")
    public String stickySessionCookie() {
        return this.stickySessionCookie;
    }

    public Balancer stickySessionCookie(String value) {
        this.stickySessionCookie = value;
        return this;
    }

    @ModelNodeBinding(detypedName="sticky-session-force")
    public Boolean stickySessionForce() {
        return this.stickySessionForce;
    }

    public Balancer stickySessionForce(Boolean value) {
        this.stickySessionForce = value;
        return this;
    }

    @ModelNodeBinding(detypedName="sticky-session-path")
    public String stickySessionPath() {
        return this.stickySessionPath;
    }

    public Balancer stickySessionPath(String value) {
        this.stickySessionPath = value;
        return this;
    }

    @ModelNodeBinding(detypedName="sticky-session-remove")
    public Boolean stickySessionRemove() {
        return this.stickySessionRemove;
    }

    public Balancer stickySessionRemove(Boolean value) {
        this.stickySessionRemove = value;
        return this;
    }

    @ModelNodeBinding(detypedName="wait-worker")
    public Integer waitWorker() {
        return this.waitWorker;
    }

    public Balancer waitWorker(Integer value) {
        this.waitWorker = value;
        return this;
    }

    public BalancerResources subresources() {
        return this.subresources;
    }

    public Balancer nodes(List<Node> value) {
        this.subresources.nodes.addAll(value);
        return this;
    }

    public Balancer node(Node value) {
        this.subresources.nodes.add(value);
        return this;
    }

    public Balancer node(String childKey, NodeConfigurator config) {
        Node child = new Node(childKey);
        if (config != null) {
            config.configure(child);
        }
        this.node(child);
        return this;
    }

    public Balancer node(String childKey) {
        this.node(childKey, null);
        return this;
    }

    public Balancer loadBalancingGroups(List<LoadBalancingGroup> value) {
        this.subresources.loadBalancingGroups.addAll(value);
        return this;
    }

    public Balancer loadBalancingGroup(LoadBalancingGroup value) {
        this.subresources.loadBalancingGroups.add(value);
        return this;
    }

    public Balancer loadBalancingGroup(String childKey, LoadBalancingGroupConfigurator config) {
        LoadBalancingGroup child = new LoadBalancingGroup(childKey);
        if (config != null) {
            config.configure(child);
        }
        this.loadBalancingGroup(child);
        return this;
    }

    public Balancer loadBalancingGroup(String childKey) {
        this.loadBalancingGroup(childKey, null);
        return this;
    }

    public class BalancerResources {
        private List<Node> nodes = new ArrayList<Node>();
        private List<LoadBalancingGroup> loadBalancingGroups = new ArrayList<LoadBalancingGroup>();

        @Subresource
        public List<Node> nodes() {
            return this.nodes;
        }

        @Subresource
        public List<LoadBalancingGroup> loadBalancingGroups() {
            return this.loadBalancingGroups;
        }
    }
}

