package org.wildfly.swarm.config;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.jca.DistributedWorkmanager;
import org.wildfly.swarm.config.jca.DistributedWorkmanagerConfigurator;
import org.wildfly.swarm.config.jca.Workmanager;
import org.wildfly.swarm.config.jca.WorkmanagerConfigurator;
import org.wildfly.swarm.config.jca.BootstrapContext;
import org.wildfly.swarm.config.jca.BootstrapContextConfigurator;
import org.wildfly.swarm.config.jca.CachedConnectionManager;
import org.wildfly.swarm.config.jca.BeanValidation;
import org.wildfly.swarm.config.jca.Tracer;
import org.wildfly.swarm.config.jca.ArchiveValidation;
/**
 * The Java EE Connector Architecture (JCA) subsystem providing general configuration for resource adapters
 */
@ResourceType("subsystem")
@Implicit
public class JCA<T extends JCA> {

	private String key;
	private JCAResources subresources = new JCAResources();
	private CachedConnectionManager cachedConnectionManager;
	private BeanValidation beanValidation;
	private Tracer tracer;
	private ArchiveValidation archiveValidation;

	public JCA() {
		this.key = "jca";
	}

	public String getKey() {
		return this.key;
	}

	public JCAResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.jca.DistributedWorkmanager objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.jca.DistributedWorkmanager objects.
	 */
	@SuppressWarnings("unchecked")
	public T distributedWorkmanagers(
			List<org.wildfly.swarm.config.jca.DistributedWorkmanager> value) {
		this.subresources.distributedWorkmanagers = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.jca.DistributedWorkmanager object to the list of subresources
	 * @param value The org.wildfly.swarm.config.jca.DistributedWorkmanager to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T distributedWorkmanager(DistributedWorkmanager value) {
		this.subresources.distributedWorkmanagers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.jca.DistributedWorkmanager object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.jca.DistributedWorkmanager resource
	 * @param config The org.wildfly.swarm.config.jca.DistributedWorkmanagerConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T distributedWorkmanager(String childKey,
			DistributedWorkmanagerConfigurator config) {
		org.wildfly.swarm.config.jca.DistributedWorkmanager child = new org.wildfly.swarm.config.jca.DistributedWorkmanager(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		distributedWorkmanager(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.jca.DistributedWorkmanager object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.jca.DistributedWorkmanager resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T distributedWorkmanager(String childKey) {
		distributedWorkmanager(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.jca.Workmanager objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.jca.Workmanager objects.
	 */
	@SuppressWarnings("unchecked")
	public T workmanagers(List<org.wildfly.swarm.config.jca.Workmanager> value) {
		this.subresources.workmanagers = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.jca.Workmanager object to the list of subresources
	 * @param value The org.wildfly.swarm.config.jca.Workmanager to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T workmanager(Workmanager value) {
		this.subresources.workmanagers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.jca.Workmanager object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.jca.Workmanager resource
	 * @param config The org.wildfly.swarm.config.jca.WorkmanagerConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T workmanager(String childKey, WorkmanagerConfigurator config) {
		org.wildfly.swarm.config.jca.Workmanager child = new org.wildfly.swarm.config.jca.Workmanager(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		workmanager(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.jca.Workmanager object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.jca.Workmanager resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T workmanager(String childKey) {
		workmanager(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.jca.BootstrapContext objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.jca.BootstrapContext objects.
	 */
	@SuppressWarnings("unchecked")
	public T bootstrapContexts(
			List<org.wildfly.swarm.config.jca.BootstrapContext> value) {
		this.subresources.bootstrapContexts = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.jca.BootstrapContext object to the list of subresources
	 * @param value The org.wildfly.swarm.config.jca.BootstrapContext to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T bootstrapContext(BootstrapContext value) {
		this.subresources.bootstrapContexts.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.jca.BootstrapContext object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.jca.BootstrapContext resource
	 * @param config The org.wildfly.swarm.config.jca.BootstrapContextConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T bootstrapContext(String childKey,
			BootstrapContextConfigurator config) {
		org.wildfly.swarm.config.jca.BootstrapContext child = new org.wildfly.swarm.config.jca.BootstrapContext(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		bootstrapContext(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.jca.BootstrapContext object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.jca.BootstrapContext resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T bootstrapContext(String childKey) {
		bootstrapContext(childKey, null);
		return (T) this;
	}

	/**
	 * Child mutators for JCA
	 */
	public class JCAResources {
		/**
		 * DistributedWorkManager for resource adapters
		 */
		private List<org.wildfly.swarm.config.jca.DistributedWorkmanager> distributedWorkmanagers = new java.util.ArrayList<>();
		/**
		 * WorkManager for resource adapters
		 */
		private List<org.wildfly.swarm.config.jca.Workmanager> workmanagers = new java.util.ArrayList<>();
		/**
		 * Bootstrap context for resource adapters
		 */
		private List<org.wildfly.swarm.config.jca.BootstrapContext> bootstrapContexts = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.jca.DistributedWorkmanager resources
		 * @return the list of resources
		 */
		@Subresource
		public List<DistributedWorkmanager> distributedWorkmanagers() {
			return this.distributedWorkmanagers;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.jca.Workmanager resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Workmanager> workmanagers() {
			return this.workmanagers;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.jca.BootstrapContext resources
		 * @return the list of resources
		 */
		@Subresource
		public List<BootstrapContext> bootstrapContexts() {
			return this.bootstrapContexts;
		}
	}

	/**
	 * Cached connection manager for resource adapters
	 */
	@Subresource
	public CachedConnectionManager cachedConnectionManager() {
		return this.cachedConnectionManager;
	}

	/**
	 * Cached connection manager for resource adapters
	 */
	@SuppressWarnings("unchecked")
	public T cachedConnectionManager(CachedConnectionManager value) {
		this.cachedConnectionManager = value;
		return (T) this;
	}

	/**
	 * Bean validation (JSR-303) for resource adapters
	 */
	@Subresource
	public BeanValidation beanValidation() {
		return this.beanValidation;
	}

	/**
	 * Bean validation (JSR-303) for resource adapters
	 */
	@SuppressWarnings("unchecked")
	public T beanValidation(BeanValidation value) {
		this.beanValidation = value;
		return (T) this;
	}

	/**
	 * Tracer for resource adapters
	 */
	@Subresource
	public Tracer tracer() {
		return this.tracer;
	}

	/**
	 * Tracer for resource adapters
	 */
	@SuppressWarnings("unchecked")
	public T tracer(Tracer value) {
		this.tracer = value;
		return (T) this;
	}

	/**
	 * Archive validation for resource adapters
	 */
	@Subresource
	public ArchiveValidation archiveValidation() {
		return this.archiveValidation;
	}

	/**
	 * Archive validation for resource adapters
	 */
	@SuppressWarnings("unchecked")
	public T archiveValidation(ArchiveValidation value) {
		this.archiveValidation = value;
		return (T) this;
	}
}