package org.wildfly.swarm.config;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * The JSF subsystem
 */
@ResourceType("subsystem")
@Implicit
public class JSF<T extends JSF> {

	private String key;
	private String defaultJsfImplSlot;

	public JSF() {
		this.key = "jsf";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Default JSF implementation slot
	 */
	@ModelNodeBinding(detypedName = "default-jsf-impl-slot")
	public String defaultJsfImplSlot() {
		return this.defaultJsfImplSlot;
	}

	/**
	 * Default JSF implementation slot
	 */
	@SuppressWarnings("unchecked")
	public T defaultJsfImplSlot(String value) {
		this.defaultJsfImplSlot = value;
		return (T) this;
	}
}