package org.wildfly.swarm.config;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.messaging_activemq.Server;
import org.wildfly.swarm.config.messaging_activemq.ServerConfigurator;
import org.wildfly.swarm.config.messaging_activemq.JMSBridge;
import org.wildfly.swarm.config.messaging_activemq.JMSBridgeConfigurator;
/**
 * The messaging-activemq subsystem.
 */
@ResourceType("subsystem")
@Implicit
public class MessagingActiveMQ<T extends MessagingActiveMQ> {

	private String key;
	private MessagingActiveMQResources subresources = new MessagingActiveMQResources();

	public MessagingActiveMQ() {
		this.key = "messaging-activemq";
	}

	public String getKey() {
		return this.key;
	}

	public MessagingActiveMQResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.Server objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.Server objects.
	 */
	@SuppressWarnings("unchecked")
	public T servers(
			List<org.wildfly.swarm.config.messaging_activemq.Server> value) {
		this.subresources.servers = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.Server object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.Server to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T server(Server value) {
		this.subresources.servers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.Server object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.Server resource
	 * @param config The org.wildfly.swarm.config.messaging_activemq.ServerConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T server(String childKey, ServerConfigurator config) {
		org.wildfly.swarm.config.messaging_activemq.Server child = new org.wildfly.swarm.config.messaging_activemq.Server(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		server(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.Server object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.Server resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T server(String childKey) {
		server(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.JMSBridge objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.JMSBridge objects.
	 */
	@SuppressWarnings("unchecked")
	public T jmsBridges(
			List<org.wildfly.swarm.config.messaging_activemq.JMSBridge> value) {
		this.subresources.jmsBridges = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.JMSBridge object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.JMSBridge to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jmsBridge(JMSBridge value) {
		this.subresources.jmsBridges.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.JMSBridge object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.JMSBridge resource
	 * @param config The org.wildfly.swarm.config.messaging_activemq.JMSBridgeConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jmsBridge(String childKey, JMSBridgeConfigurator config) {
		org.wildfly.swarm.config.messaging_activemq.JMSBridge child = new org.wildfly.swarm.config.messaging_activemq.JMSBridge(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		jmsBridge(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.JMSBridge object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.JMSBridge resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jmsBridge(String childKey) {
		jmsBridge(childKey, null);
		return (T) this;
	}

	/**
	 * Child mutators for MessagingActiveMQ
	 */
	public class MessagingActiveMQResources {
		/**
		 * An ActiveMQ server instance.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.Server> servers = new java.util.ArrayList<>();
		/**
		 * A JMS bridge instance.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.JMSBridge> jmsBridges = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.Server resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Server> servers() {
			return this.servers;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.JMSBridge resources
		 * @return the list of resources
		 */
		@Subresource
		public List<JMSBridge> jmsBridges() {
			return this.jmsBridges;
		}
	}
}