package org.wildfly.swarm.config.ejb3;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * The EJB3 Asynchronous Invocation Service
 */
@ResourceType("service")
@Implicit
public class AsyncService<T extends AsyncService> {

	private String key;
	private String threadPoolName;

	public AsyncService() {
		this.key = "async";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The name of the thread pool which handles asynchronous invocations
	 */
	@ModelNodeBinding(detypedName = "thread-pool-name")
	public String threadPoolName() {
		return this.threadPoolName;
	}

	/**
	 * The name of the thread pool which handles asynchronous invocations
	 */
	@SuppressWarnings("unchecked")
	public AsyncService threadPoolName(String value) {
		this.threadPoolName = value;
		return (AsyncService) this;
	}
}