package org.wildfly.swarm.config.ejb3;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * The options that will be used during the EJB remote channel creation
 */
@ResourceType("channel-creation-options")
public class ChannelCreationOptions<T extends ChannelCreationOptions> {

	private String key;
	private String type;
	private String value;

	public ChannelCreationOptions(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The type of the channel creation option
	 */
	@ModelNodeBinding(detypedName = "type")
	public String type() {
		return this.type;
	}

	/**
	 * The type of the channel creation option
	 */
	@SuppressWarnings("unchecked")
	public ChannelCreationOptions type(String value) {
		this.type = value;
		return (ChannelCreationOptions) this;
	}

	/**
	 * The value for the EJB remote channel creation option
	 */
	@ModelNodeBinding(detypedName = "value")
	public String value() {
		return this.value;
	}

	/**
	 * The value for the EJB remote channel creation option
	 */
	@SuppressWarnings("unchecked")
	public ChannelCreationOptions value(String value) {
		this.value = value;
		return (ChannelCreationOptions) this;
	}
}