package org.wildfly.swarm.config.ejb3;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * Delivery group to manage delivery for mdbs
 */
@ResourceType("mdb-delivery-group")
public class MDBDeliveryGroup<T extends MDBDeliveryGroup> {

	private String key;
	private Boolean active;

	public MDBDeliveryGroup(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Indicates if delivery for all MDBs belonging to this group is active
	 */
	@ModelNodeBinding(detypedName = "active")
	public Boolean active() {
		return this.active;
	}

	/**
	 * Indicates if delivery for all MDBs belonging to this group is active
	 */
	@SuppressWarnings("unchecked")
	public MDBDeliveryGroup active(Boolean value) {
		this.active = value;
		return (MDBDeliveryGroup) this;
	}
}