package org.wildfly.swarm.config.ejb3;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.ejb3.service.FileDataStore;
import org.wildfly.swarm.config.ejb3.service.FileDataStoreConfigurator;
import org.wildfly.swarm.config.ejb3.service.DatabaseDataStore;
import org.wildfly.swarm.config.ejb3.service.DatabaseDataStoreConfigurator;
/**
 * The EJB timer service
 */
@ResourceType("service")
@Implicit
public class TimerService<T extends TimerService> {

	private String key;
	private String defaultDataStore;
	private String threadPoolName;
	private TimerServiceResources subresources = new TimerServiceResources();

	public TimerService() {
		this.key = "timer-service";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The default data store used for persistent timers
	 */
	@ModelNodeBinding(detypedName = "default-data-store")
	public String defaultDataStore() {
		return this.defaultDataStore;
	}

	/**
	 * The default data store used for persistent timers
	 */
	@SuppressWarnings("unchecked")
	public TimerService defaultDataStore(String value) {
		this.defaultDataStore = value;
		return (TimerService) this;
	}

	/**
	 * The name of the thread pool used to run timer service invocations
	 */
	@ModelNodeBinding(detypedName = "thread-pool-name")
	public String threadPoolName() {
		return this.threadPoolName;
	}

	/**
	 * The name of the thread pool used to run timer service invocations
	 */
	@SuppressWarnings("unchecked")
	public TimerService threadPoolName(String value) {
		this.threadPoolName = value;
		return (TimerService) this;
	}

	public TimerServiceResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.ejb3.service.FileDataStore objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.ejb3.service.FileDataStore objects.
	 */
	@SuppressWarnings("unchecked")
	public TimerService fileDataStores(
			List<org.wildfly.swarm.config.ejb3.service.FileDataStore> value) {
		this.subresources.fileDataStores = value;
		return (TimerService) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.ejb3.service.FileDataStore object to the list of subresources
	 * @param value The org.wildfly.swarm.config.ejb3.service.FileDataStore to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public TimerService fileDataStore(FileDataStore value) {
		this.subresources.fileDataStores.add(value);
		return (TimerService) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.ejb3.service.FileDataStore object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.ejb3.service.FileDataStore resource
	 * @param config The org.wildfly.swarm.config.ejb3.service.FileDataStoreConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public TimerService fileDataStore(String childKey,
			FileDataStoreConfigurator config) {
		org.wildfly.swarm.config.ejb3.service.FileDataStore child = new org.wildfly.swarm.config.ejb3.service.FileDataStore(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		fileDataStore(child);
		return (TimerService) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.ejb3.service.FileDataStore object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.ejb3.service.FileDataStore resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public TimerService fileDataStore(String childKey) {
		fileDataStore(childKey, null);
		return (TimerService) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.ejb3.service.DatabaseDataStore objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.ejb3.service.DatabaseDataStore objects.
	 */
	@SuppressWarnings("unchecked")
	public TimerService databaseDataStores(
			List<org.wildfly.swarm.config.ejb3.service.DatabaseDataStore> value) {
		this.subresources.databaseDataStores = value;
		return (TimerService) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.ejb3.service.DatabaseDataStore object to the list of subresources
	 * @param value The org.wildfly.swarm.config.ejb3.service.DatabaseDataStore to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public TimerService databaseDataStore(DatabaseDataStore value) {
		this.subresources.databaseDataStores.add(value);
		return (TimerService) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.ejb3.service.DatabaseDataStore object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.ejb3.service.DatabaseDataStore resource
	 * @param config The org.wildfly.swarm.config.ejb3.service.DatabaseDataStoreConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public TimerService databaseDataStore(String childKey,
			DatabaseDataStoreConfigurator config) {
		org.wildfly.swarm.config.ejb3.service.DatabaseDataStore child = new org.wildfly.swarm.config.ejb3.service.DatabaseDataStore(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		databaseDataStore(child);
		return (TimerService) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.ejb3.service.DatabaseDataStore object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.ejb3.service.DatabaseDataStore resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public TimerService databaseDataStore(String childKey) {
		databaseDataStore(childKey, null);
		return (TimerService) this;
	}

	/**
	 * Child mutators for TimerService
	 */
	public class TimerServiceResources {
		/**
		 * A JVM local file store that stores persistent EJB timers
		 */
		private List<org.wildfly.swarm.config.ejb3.service.FileDataStore> fileDataStores = new java.util.ArrayList<>();
		/**
		 * An database based store for persistent EJB timers.
		 */
		private List<org.wildfly.swarm.config.ejb3.service.DatabaseDataStore> databaseDataStores = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.ejb3.service.FileDataStore resources
		 * @return the list of resources
		 */
		@Subresource
		public List<FileDataStore> fileDataStores() {
			return this.fileDataStores;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.ejb3.service.DatabaseDataStore resources
		 * @return the list of resources
		 */
		@Subresource
		public List<DatabaseDataStore> databaseDataStores() {
			return this.databaseDataStores;
		}
	}
}