package org.wildfly.swarm.config.ejb3.remoting_profile;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.ejb3.ChannelCreationOptions;
import org.wildfly.swarm.config.ejb3.ChannelCreationOptionsConfigurator;
/**
 * A remoting ejb receiver reference included in the profile
 */
@ResourceType("remoting-ejb-receiver")
public class RemotingEJBReceiver<T extends RemotingEJBReceiver> {

	private String key;
	private Long connectTimeout;
	private String outboundConnectionRef;
	private RemotingEJBReceiverResources subresources = new RemotingEJBReceiverResources();

	public RemotingEJBReceiver(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Remoting ejb receiver connect timeout
	 */
	@ModelNodeBinding(detypedName = "connect-timeout")
	public Long connectTimeout() {
		return this.connectTimeout;
	}

	/**
	 * Remoting ejb receiver connect timeout
	 */
	@SuppressWarnings("unchecked")
	public RemotingEJBReceiver connectTimeout(Long value) {
		this.connectTimeout = value;
		return (RemotingEJBReceiver) this;
	}

	/**
	 * Name of outbound connection that will be used by the ejb receiver
	 */
	@ModelNodeBinding(detypedName = "outbound-connection-ref")
	public String outboundConnectionRef() {
		return this.outboundConnectionRef;
	}

	/**
	 * Name of outbound connection that will be used by the ejb receiver
	 */
	@SuppressWarnings("unchecked")
	public RemotingEJBReceiver outboundConnectionRef(String value) {
		this.outboundConnectionRef = value;
		return (RemotingEJBReceiver) this;
	}

	public RemotingEJBReceiverResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.ejb3.ChannelCreationOptions objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.ejb3.ChannelCreationOptions objects.
	 */
	@SuppressWarnings("unchecked")
	public RemotingEJBReceiver channelCreationOptions(
			List<org.wildfly.swarm.config.ejb3.ChannelCreationOptions> value) {
		this.subresources.channelCreationOptions = value;
		return (RemotingEJBReceiver) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.ejb3.ChannelCreationOptions object to the list of subresources
	 * @param value The org.wildfly.swarm.config.ejb3.ChannelCreationOptions to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public RemotingEJBReceiver channelCreationOptions(
			ChannelCreationOptions value) {
		this.subresources.channelCreationOptions.add(value);
		return (RemotingEJBReceiver) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.ejb3.ChannelCreationOptions object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.ejb3.ChannelCreationOptions resource
	 * @param config The org.wildfly.swarm.config.ejb3.ChannelCreationOptionsConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public RemotingEJBReceiver channelCreationOptions(String childKey,
			ChannelCreationOptionsConfigurator config) {
		org.wildfly.swarm.config.ejb3.ChannelCreationOptions child = new org.wildfly.swarm.config.ejb3.ChannelCreationOptions(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		channelCreationOptions(child);
		return (RemotingEJBReceiver) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.ejb3.ChannelCreationOptions object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.ejb3.ChannelCreationOptions resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public RemotingEJBReceiver channelCreationOptions(String childKey) {
		channelCreationOptions(childKey, null);
		return (RemotingEJBReceiver) this;
	}

	/**
	 * Child mutators for RemotingEJBReceiver
	 */
	public class RemotingEJBReceiverResources {
		/**
		 * The options that will be used during the EJB remote channel creation
		 */
		private List<org.wildfly.swarm.config.ejb3.ChannelCreationOptions> channelCreationOptions = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.ejb3.ChannelCreationOptions resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ChannelCreationOptions> channelCreationOptions() {
			return this.channelCreationOptions;
		}
	}
}