package org.wildfly.swarm.config.logging;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * A custom formatter to be used with handlers. Note that most log records are formatted in the printf format. Formatters may require invocation of the org.jboss.logmanager.ExtLogRecord#getFormattedMessage() for the message to be properly formatted.
 */
@ResourceType("custom-formatter")
public class CustomFormatter<T extends CustomFormatter> {

	private String key;
	private String attributeClass;
	private String module;
	private Map properties = new java.util.HashMap<String, Object>();

	public CustomFormatter(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The logging handler class to be used.
	 */
	@ModelNodeBinding(detypedName = "class")
	public String attributeClass() {
		return this.attributeClass;
	}

	/**
	 * The logging handler class to be used.
	 */
	@SuppressWarnings("unchecked")
	public CustomFormatter attributeClass(String value) {
		this.attributeClass = value;
		return (CustomFormatter) this;
	}

	/**
	 * The module that the logging handler depends on.
	 */
	@ModelNodeBinding(detypedName = "module")
	public String module() {
		return this.module;
	}

	/**
	 * The module that the logging handler depends on.
	 */
	@SuppressWarnings("unchecked")
	public CustomFormatter module(String value) {
		this.module = value;
		return (CustomFormatter) this;
	}

	/**
	 * Defines the properties used for the logging handler. All properties must be accessible via a setter method.
	 */
	@ModelNodeBinding(detypedName = "properties")
	public Map properties() {
		return this.properties;
	}

	/**
	 * Defines the properties used for the logging handler. All properties must be accessible via a setter method.
	 */
	@SuppressWarnings("unchecked")
	public CustomFormatter properties(Map value) {
		this.properties = value;
		return (CustomFormatter) this;
	}

	/**
	 * Defines the properties used for the logging handler. All properties must be accessible via a setter method.
	 */
	public CustomFormatter propertiesEntry(String key, Object value) {
		this.properties.put(key, value);
		return (CustomFormatter) this;
	}
}