package org.wildfly.swarm.config.mail.mail_session;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * Mail session server
 */
@ResourceType("server")
@Implicit
public class POP3Server<T extends POP3Server> {

	private String key;
	private String outboundSocketBindingRef;
	private String password;
	private Boolean ssl;
	private Boolean tls;
	private String username;

	public POP3Server() {
		this.key = "pop3";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Outbound Socket binding to mail server
	 */
	@ModelNodeBinding(detypedName = "outbound-socket-binding-ref")
	public String outboundSocketBindingRef() {
		return this.outboundSocketBindingRef;
	}

	/**
	 * Outbound Socket binding to mail server
	 */
	@SuppressWarnings("unchecked")
	public POP3Server outboundSocketBindingRef(String value) {
		this.outboundSocketBindingRef = value;
		return (POP3Server) this;
	}

	/**
	 * Password to authenticate on server
	 */
	@ModelNodeBinding(detypedName = "password")
	public String password() {
		return this.password;
	}

	/**
	 * Password to authenticate on server
	 */
	@SuppressWarnings("unchecked")
	public POP3Server password(String value) {
		this.password = value;
		return (POP3Server) this;
	}

	/**
	 * Does server require SSL?
	 */
	@ModelNodeBinding(detypedName = "ssl")
	public Boolean ssl() {
		return this.ssl;
	}

	/**
	 * Does server require SSL?
	 */
	@SuppressWarnings("unchecked")
	public POP3Server ssl(Boolean value) {
		this.ssl = value;
		return (POP3Server) this;
	}

	/**
	 * Does server require TLS?
	 */
	@ModelNodeBinding(detypedName = "tls")
	public Boolean tls() {
		return this.tls;
	}

	/**
	 * Does server require TLS?
	 */
	@SuppressWarnings("unchecked")
	public POP3Server tls(Boolean value) {
		this.tls = value;
		return (POP3Server) this;
	}

	/**
	 * Username to authenticate on server
	 */
	@ModelNodeBinding(detypedName = "username")
	public String username() {
		return this.username;
	}

	/**
	 * Username to authenticate on server
	 */
	@SuppressWarnings("unchecked")
	public POP3Server username(String value) {
		this.username = value;
		return (POP3Server) this;
	}
}