package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
/**
 * A broadcast group is the means by which a server broadcasts connectors over the network.
 */
@ResourceType("broadcast-group")
public class BroadcastGroup<T extends BroadcastGroup> {

	private String key;
	private Long broadcastPeriod;
	private List<String> connectors = new java.util.ArrayList<>();
	private String jgroupsChannel;
	private String jgroupsStack;
	private String socketBinding;
	private Boolean started;

	public BroadcastGroup(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The period in milliseconds between consecutive broadcasts.
	 */
	@ModelNodeBinding(detypedName = "broadcast-period")
	public Long broadcastPeriod() {
		return this.broadcastPeriod;
	}

	/**
	 * The period in milliseconds between consecutive broadcasts.
	 */
	@SuppressWarnings("unchecked")
	public BroadcastGroup broadcastPeriod(Long value) {
		this.broadcastPeriod = value;
		return (BroadcastGroup) this;
	}

	/**
	 * Specifies the names of connectors that will be broadcast.
	 */
	@ModelNodeBinding(detypedName = "connectors")
	public List<String> connectors() {
		return this.connectors;
	}

	/**
	 * Specifies the names of connectors that will be broadcast.
	 */
	@SuppressWarnings("unchecked")
	public BroadcastGroup connectors(List<String> value) {
		this.connectors = value;
		return (BroadcastGroup) this;
	}

	/**
	 * Specifies the names of connectors that will be broadcast.
	 */
	public BroadcastGroup connectorsValue(String value) {
		this.connectors.add(value);
		return (BroadcastGroup) this;
	}

	/**
	 * The name used by a JGroups channel to join a cluster.
	 */
	@ModelNodeBinding(detypedName = "jgroups-channel")
	public String jgroupsChannel() {
		return this.jgroupsChannel;
	}

	/**
	 * The name used by a JGroups channel to join a cluster.
	 */
	@SuppressWarnings("unchecked")
	public BroadcastGroup jgroupsChannel(String value) {
		this.jgroupsChannel = value;
		return (BroadcastGroup) this;
	}

	/**
	 * The name of a stack defined in the org.jboss.as.clustering.jgroups subsystem that is used to form a cluster.
	 */
	@ModelNodeBinding(detypedName = "jgroups-stack")
	public String jgroupsStack() {
		return this.jgroupsStack;
	}

	/**
	 * The name of a stack defined in the org.jboss.as.clustering.jgroups subsystem that is used to form a cluster.
	 */
	@SuppressWarnings("unchecked")
	public BroadcastGroup jgroupsStack(String value) {
		this.jgroupsStack = value;
		return (BroadcastGroup) this;
	}

	/**
	 * The broadcast group socket binding.
	 */
	@ModelNodeBinding(detypedName = "socket-binding")
	public String socketBinding() {
		return this.socketBinding;
	}

	/**
	 * The broadcast group socket binding.
	 */
	@SuppressWarnings("unchecked")
	public BroadcastGroup socketBinding(String value) {
		this.socketBinding = value;
		return (BroadcastGroup) this;
	}

	/**
	 * Whether the broadcast group is started.
	 */
	@ModelNodeBinding(detypedName = "started")
	public Boolean started() {
		return this.started;
	}

	/**
	 * Whether the broadcast group is started.
	 */
	@SuppressWarnings("unchecked")
	public BroadcastGroup started(Boolean value) {
		this.started = value;
		return (BroadcastGroup) this;
	}
}