package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.math.BigDecimal;
import java.util.List;
/**
 * Cluster connections group servers into clusters so that messages can be load balanced between the nodes of the cluster.
 */
@ResourceType("cluster-connection")
public class ClusterConnection<T extends ClusterConnection> {

	private String key;
	private Boolean allowDirectConnectionsOnly;
	private Long callFailoverTimeout;
	private Long callTimeout;
	private Long checkPeriod;
	private String clusterConnectionAddress;
	private Integer confirmationWindowSize;
	private Long connectionTtl;
	private String connectorName;
	private String discoveryGroup;
	private Integer initialConnectAttempts;
	private Integer maxHops;
	private Long maxRetryInterval;
	private String messageLoadBalancingType;
	private Integer minLargeMessageSize;
	private String nodeId;
	private Integer notificationAttempts;
	private Long notificationInterval;
	private Integer reconnectAttempts;
	private Long retryInterval;
	private BigDecimal retryIntervalMultiplier;
	private Boolean started;
	private List<String> staticConnectors = new java.util.ArrayList<>();
	private String topology;
	private Boolean useDuplicateDetection;

	public ClusterConnection(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Whether, if a node learns of the existence of a node that is more than 1 hop away, we do not create a bridge for direct cluster connection. Only relevant if 'static-connectors' is defined.
	 */
	@ModelNodeBinding(detypedName = "allow-direct-connections-only")
	public Boolean allowDirectConnectionsOnly() {
		return this.allowDirectConnectionsOnly;
	}

	/**
	 * Whether, if a node learns of the existence of a node that is more than 1 hop away, we do not create a bridge for direct cluster connection. Only relevant if 'static-connectors' is defined.
	 */
	@SuppressWarnings("unchecked")
	public ClusterConnection allowDirectConnectionsOnly(Boolean value) {
		this.allowDirectConnectionsOnly = value;
		return (ClusterConnection) this;
	}

	/**
	 * The timeout to use when fail over is in process (in ms) for remote calls made by the cluster connection.
	 */
	@ModelNodeBinding(detypedName = "call-failover-timeout")
	public Long callFailoverTimeout() {
		return this.callFailoverTimeout;
	}

	/**
	 * The timeout to use when fail over is in process (in ms) for remote calls made by the cluster connection.
	 */
	@SuppressWarnings("unchecked")
	public ClusterConnection callFailoverTimeout(Long value) {
		this.callFailoverTimeout = value;
		return (ClusterConnection) this;
	}

	/**
	 * The timeout (in ms) for remote calls made by the cluster connection.
	 */
	@ModelNodeBinding(detypedName = "call-timeout")
	public Long callTimeout() {
		return this.callTimeout;
	}

	/**
	 * The timeout (in ms) for remote calls made by the cluster connection.
	 */
	@SuppressWarnings("unchecked")
	public ClusterConnection callTimeout(Long value) {
		this.callTimeout = value;
		return (ClusterConnection) this;
	}

	/**
	 * The period (in milliseconds) between client failure check.
	 */
	@ModelNodeBinding(detypedName = "check-period")
	public Long checkPeriod() {
		return this.checkPeriod;
	}

	/**
	 * The period (in milliseconds) between client failure check.
	 */
	@SuppressWarnings("unchecked")
	public ClusterConnection checkPeriod(Long value) {
		this.checkPeriod = value;
		return (ClusterConnection) this;
	}

	/**
	 * Each cluster connection only applies to messages sent to an address that starts with this value.
	 */
	@ModelNodeBinding(detypedName = "cluster-connection-address")
	public String clusterConnectionAddress() {
		return this.clusterConnectionAddress;
	}

	/**
	 * Each cluster connection only applies to messages sent to an address that starts with this value.
	 */
	@SuppressWarnings("unchecked")
	public ClusterConnection clusterConnectionAddress(String value) {
		this.clusterConnectionAddress = value;
		return (ClusterConnection) this;
	}

	/**
	 * The confirmation-window-size to use for the connection used to forward messages to a target node.
	 */
	@ModelNodeBinding(detypedName = "confirmation-window-size")
	public Integer confirmationWindowSize() {
		return this.confirmationWindowSize;
	}

	/**
	 * The confirmation-window-size to use for the connection used to forward messages to a target node.
	 */
	@SuppressWarnings("unchecked")
	public ClusterConnection confirmationWindowSize(Integer value) {
		this.confirmationWindowSize = value;
		return (ClusterConnection) this;
	}

	/**
	 * The maximum time (in milliseconds) for which the connections used by the cluster connections are considered alive (in the absence of heartbeat).
	 */
	@ModelNodeBinding(detypedName = "connection-ttl")
	public Long connectionTtl() {
		return this.connectionTtl;
	}

	/**
	 * The maximum time (in milliseconds) for which the connections used by the cluster connections are considered alive (in the absence of heartbeat).
	 */
	@SuppressWarnings("unchecked")
	public ClusterConnection connectionTtl(Long value) {
		this.connectionTtl = value;
		return (ClusterConnection) this;
	}

	/**
	 * The name of connector to use for live connection
	 */
	@ModelNodeBinding(detypedName = "connector-name")
	public String connectorName() {
		return this.connectorName;
	}

	/**
	 * The name of connector to use for live connection
	 */
	@SuppressWarnings("unchecked")
	public ClusterConnection connectorName(String value) {
		this.connectorName = value;
		return (ClusterConnection) this;
	}

	/**
	 * The discovery group used to obtain the list of other servers in the cluster to which this cluster connection will make connections. Must be undefined (null) if 'static-connectors' is defined.
	 */
	@ModelNodeBinding(detypedName = "discovery-group")
	public String discoveryGroup() {
		return this.discoveryGroup;
	}

	/**
	 * The discovery group used to obtain the list of other servers in the cluster to which this cluster connection will make connections. Must be undefined (null) if 'static-connectors' is defined.
	 */
	@SuppressWarnings("unchecked")
	public ClusterConnection discoveryGroup(String value) {
		this.discoveryGroup = value;
		return (ClusterConnection) this;
	}

	/**
	 * The number of attempts to connect initially with this cluster connection.
	 */
	@ModelNodeBinding(detypedName = "initial-connect-attempts")
	public Integer initialConnectAttempts() {
		return this.initialConnectAttempts;
	}

	/**
	 * The number of attempts to connect initially with this cluster connection.
	 */
	@SuppressWarnings("unchecked")
	public ClusterConnection initialConnectAttempts(Integer value) {
		this.initialConnectAttempts = value;
		return (ClusterConnection) this;
	}

	/**
	 * The maximum number of times a message can be forwarded. ActiveMQ can be configured to also load balance messages to nodes which might be connected to it only indirectly with other ActiveMQ servers as intermediates in a chain.
	 */
	@ModelNodeBinding(detypedName = "max-hops")
	public Integer maxHops() {
		return this.maxHops;
	}

	/**
	 * The maximum number of times a message can be forwarded. ActiveMQ can be configured to also load balance messages to nodes which might be connected to it only indirectly with other ActiveMQ servers as intermediates in a chain.
	 */
	@SuppressWarnings("unchecked")
	public ClusterConnection maxHops(Integer value) {
		this.maxHops = value;
		return (ClusterConnection) this;
	}

	/**
	 * The maximum interval of time used to retry connections
	 */
	@ModelNodeBinding(detypedName = "max-retry-interval")
	public Long maxRetryInterval() {
		return this.maxRetryInterval;
	}

	/**
	 * The maximum interval of time used to retry connections
	 */
	@SuppressWarnings("unchecked")
	public ClusterConnection maxRetryInterval(Long value) {
		this.maxRetryInterval = value;
		return (ClusterConnection) this;
	}

	/**
	 * The type of message load balancing provided by the cluster connection.
	 */
	@ModelNodeBinding(detypedName = "message-load-balancing-type")
	public String messageLoadBalancingType() {
		return this.messageLoadBalancingType;
	}

	/**
	 * The type of message load balancing provided by the cluster connection.
	 */
	@SuppressWarnings("unchecked")
	public ClusterConnection messageLoadBalancingType(String value) {
		this.messageLoadBalancingType = value;
		return (ClusterConnection) this;
	}

	/**
	 * The minimum size (in bytes) for a message before it is considered as a large message.
	 */
	@ModelNodeBinding(detypedName = "min-large-message-size")
	public Integer minLargeMessageSize() {
		return this.minLargeMessageSize;
	}

	/**
	 * The minimum size (in bytes) for a message before it is considered as a large message.
	 */
	@SuppressWarnings("unchecked")
	public ClusterConnection minLargeMessageSize(Integer value) {
		this.minLargeMessageSize = value;
		return (ClusterConnection) this;
	}

	/**
	 * The node ID used by this cluster connection.
	 */
	@ModelNodeBinding(detypedName = "node-id")
	public String nodeId() {
		return this.nodeId;
	}

	/**
	 * The node ID used by this cluster connection.
	 */
	@SuppressWarnings("unchecked")
	public ClusterConnection nodeId(String value) {
		this.nodeId = value;
		return (ClusterConnection) this;
	}

	/**
	 * How many times the cluster connection will broadcast itself
	 */
	@ModelNodeBinding(detypedName = "notification-attempts")
	public Integer notificationAttempts() {
		return this.notificationAttempts;
	}

	/**
	 * How many times the cluster connection will broadcast itself
	 */
	@SuppressWarnings("unchecked")
	public ClusterConnection notificationAttempts(Integer value) {
		this.notificationAttempts = value;
		return (ClusterConnection) this;
	}

	/**
	 * How often the cluster connection will broadcast itself
	 */
	@ModelNodeBinding(detypedName = "notification-interval")
	public Long notificationInterval() {
		return this.notificationInterval;
	}

	/**
	 * How often the cluster connection will broadcast itself
	 */
	@SuppressWarnings("unchecked")
	public ClusterConnection notificationInterval(Long value) {
		this.notificationInterval = value;
		return (ClusterConnection) this;
	}

	/**
	 * The total number of reconnect attempts the bridge will make before giving up and shutting down. A value of -1 signifies an unlimited number of attempts.
	 */
	@ModelNodeBinding(detypedName = "reconnect-attempts")
	public Integer reconnectAttempts() {
		return this.reconnectAttempts;
	}

	/**
	 * The total number of reconnect attempts the bridge will make before giving up and shutting down. A value of -1 signifies an unlimited number of attempts.
	 */
	@SuppressWarnings("unchecked")
	public ClusterConnection reconnectAttempts(Integer value) {
		this.reconnectAttempts = value;
		return (ClusterConnection) this;
	}

	/**
	 * The period in milliseconds between subsequent attempts to reconnect to a target server, if the connection to the target server has failed.
	 */
	@ModelNodeBinding(detypedName = "retry-interval")
	public Long retryInterval() {
		return this.retryInterval;
	}

	/**
	 * The period in milliseconds between subsequent attempts to reconnect to a target server, if the connection to the target server has failed.
	 */
	@SuppressWarnings("unchecked")
	public ClusterConnection retryInterval(Long value) {
		this.retryInterval = value;
		return (ClusterConnection) this;
	}

	/**
	 * A multiplier to apply to the time since the last retry to compute the time to the next retry. This allows you to implement an exponential backoff between retry attempts.
	 */
	@ModelNodeBinding(detypedName = "retry-interval-multiplier")
	public BigDecimal retryIntervalMultiplier() {
		return this.retryIntervalMultiplier;
	}

	/**
	 * A multiplier to apply to the time since the last retry to compute the time to the next retry. This allows you to implement an exponential backoff between retry attempts.
	 */
	@SuppressWarnings("unchecked")
	public ClusterConnection retryIntervalMultiplier(BigDecimal value) {
		this.retryIntervalMultiplier = value;
		return (ClusterConnection) this;
	}

	/**
	 * Whether the cluster connection is started.
	 */
	@ModelNodeBinding(detypedName = "started")
	public Boolean started() {
		return this.started;
	}

	/**
	 * Whether the cluster connection is started.
	 */
	@SuppressWarnings("unchecked")
	public ClusterConnection started(Boolean value) {
		this.started = value;
		return (ClusterConnection) this;
	}

	/**
	 * The statically defined list of connectors to which this cluster connection will make connections. Must be undefined (null) if 'discovery-group-name' is defined.
	 */
	@ModelNodeBinding(detypedName = "static-connectors")
	public List<String> staticConnectors() {
		return this.staticConnectors;
	}

	/**
	 * The statically defined list of connectors to which this cluster connection will make connections. Must be undefined (null) if 'discovery-group-name' is defined.
	 */
	@SuppressWarnings("unchecked")
	public ClusterConnection staticConnectors(List<String> value) {
		this.staticConnectors = value;
		return (ClusterConnection) this;
	}

	/**
	 * The statically defined list of connectors to which this cluster connection will make connections. Must be undefined (null) if 'discovery-group-name' is defined.
	 */
	public ClusterConnection staticConnectorsValue(String value) {
		this.staticConnectors.add(value);
		return (ClusterConnection) this;
	}

	/**
	 * The topology of the nodes that this cluster connection is aware of.
	 */
	@ModelNodeBinding(detypedName = "topology")
	public String topology() {
		return this.topology;
	}

	/**
	 * The topology of the nodes that this cluster connection is aware of.
	 */
	@SuppressWarnings("unchecked")
	public ClusterConnection topology(String value) {
		this.topology = value;
		return (ClusterConnection) this;
	}

	/**
	 * Whether the bridge will automatically insert a duplicate id property into each message that it forwards.
	 */
	@ModelNodeBinding(detypedName = "use-duplicate-detection")
	public Boolean useDuplicateDetection() {
		return this.useDuplicateDetection;
	}

	/**
	 * Whether the bridge will automatically insert a duplicate id property into each message that it forwards.
	 */
	@SuppressWarnings("unchecked")
	public ClusterConnection useDuplicateDetection(Boolean value) {
		this.useDuplicateDetection = value;
		return (ClusterConnection) this;
	}
}