package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
/**
 * Defines a JMS queue.
 */
@ResourceType("jms-queue")
public class JMSQueue<T extends JMSQueue> {

	private String key;
	private Integer consumerCount;
	private String deadLetterAddress;
	private Integer deliveringCount;
	private Boolean durable;
	private List<String> entries = new java.util.ArrayList<>();
	private String expiryAddress;
	private List<String> legacyEntries = new java.util.ArrayList<>();
	private Long messageCount;
	private Long messagesAdded;
	private Boolean paused;
	private String queueAddress;
	private Long scheduledCount;
	private String selector;
	private Boolean temporary;

	public JMSQueue(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The number of consumers consuming messages from this queue.
	 */
	@ModelNodeBinding(detypedName = "consumer-count")
	public Integer consumerCount() {
		return this.consumerCount;
	}

	/**
	 * The number of consumers consuming messages from this queue.
	 */
	@SuppressWarnings("unchecked")
	public JMSQueue consumerCount(Integer value) {
		this.consumerCount = value;
		return (JMSQueue) this;
	}

	/**
	 * The address to send dead messages to.
	 */
	@ModelNodeBinding(detypedName = "dead-letter-address")
	public String deadLetterAddress() {
		return this.deadLetterAddress;
	}

	/**
	 * The address to send dead messages to.
	 */
	@SuppressWarnings("unchecked")
	public JMSQueue deadLetterAddress(String value) {
		this.deadLetterAddress = value;
		return (JMSQueue) this;
	}

	/**
	 * The number of messages that this queue is currently delivering to its consumers.
	 */
	@ModelNodeBinding(detypedName = "delivering-count")
	public Integer deliveringCount() {
		return this.deliveringCount;
	}

	/**
	 * The number of messages that this queue is currently delivering to its consumers.
	 */
	@SuppressWarnings("unchecked")
	public JMSQueue deliveringCount(Integer value) {
		this.deliveringCount = value;
		return (JMSQueue) this;
	}

	/**
	 * Whether the queue is durable or not.
	 */
	@ModelNodeBinding(detypedName = "durable")
	public Boolean durable() {
		return this.durable;
	}

	/**
	 * Whether the queue is durable or not.
	 */
	@SuppressWarnings("unchecked")
	public JMSQueue durable(Boolean value) {
		this.durable = value;
		return (JMSQueue) this;
	}

	/**
	 * The jndi names the queue will be bound to.
	 */
	@ModelNodeBinding(detypedName = "entries")
	public List<String> entries() {
		return this.entries;
	}

	/**
	 * The jndi names the queue will be bound to.
	 */
	@SuppressWarnings("unchecked")
	public JMSQueue entries(List<String> value) {
		this.entries = value;
		return (JMSQueue) this;
	}

	/**
	 * The jndi names the queue will be bound to.
	 */
	public JMSQueue entriesValue(String value) {
		this.entries.add(value);
		return (JMSQueue) this;
	}

	/**
	 * The address to send expired messages to.
	 */
	@ModelNodeBinding(detypedName = "expiry-address")
	public String expiryAddress() {
		return this.expiryAddress;
	}

	/**
	 * The address to send expired messages to.
	 */
	@SuppressWarnings("unchecked")
	public JMSQueue expiryAddress(String value) {
		this.expiryAddress = value;
		return (JMSQueue) this;
	}

	/**
	 * The jndi names the queue will be bound to.
	 */
	@ModelNodeBinding(detypedName = "legacy-entries")
	public List<String> legacyEntries() {
		return this.legacyEntries;
	}

	/**
	 * The jndi names the queue will be bound to.
	 */
	@SuppressWarnings("unchecked")
	public JMSQueue legacyEntries(List<String> value) {
		this.legacyEntries = value;
		return (JMSQueue) this;
	}

	/**
	 * The jndi names the queue will be bound to.
	 */
	public JMSQueue legacyEntriesValue(String value) {
		this.legacyEntries.add(value);
		return (JMSQueue) this;
	}

	/**
	 * The number of messages currently in this queue.
	 */
	@ModelNodeBinding(detypedName = "message-count")
	public Long messageCount() {
		return this.messageCount;
	}

	/**
	 * The number of messages currently in this queue.
	 */
	@SuppressWarnings("unchecked")
	public JMSQueue messageCount(Long value) {
		this.messageCount = value;
		return (JMSQueue) this;
	}

	/**
	 * The number of messages added to this queue since it was created.
	 */
	@ModelNodeBinding(detypedName = "messages-added")
	public Long messagesAdded() {
		return this.messagesAdded;
	}

	/**
	 * The number of messages added to this queue since it was created.
	 */
	@SuppressWarnings("unchecked")
	public JMSQueue messagesAdded(Long value) {
		this.messagesAdded = value;
		return (JMSQueue) this;
	}

	/**
	 * Whether the queue is paused.
	 */
	@ModelNodeBinding(detypedName = "paused")
	public Boolean paused() {
		return this.paused;
	}

	/**
	 * Whether the queue is paused.
	 */
	@SuppressWarnings("unchecked")
	public JMSQueue paused(Boolean value) {
		this.paused = value;
		return (JMSQueue) this;
	}

	/**
	 * The queue address defines what address is used for routing messages.
	 */
	@ModelNodeBinding(detypedName = "queue-address")
	public String queueAddress() {
		return this.queueAddress;
	}

	/**
	 * The queue address defines what address is used for routing messages.
	 */
	@SuppressWarnings("unchecked")
	public JMSQueue queueAddress(String value) {
		this.queueAddress = value;
		return (JMSQueue) this;
	}

	/**
	 * The number of scheduled messages in this queue.
	 */
	@ModelNodeBinding(detypedName = "scheduled-count")
	public Long scheduledCount() {
		return this.scheduledCount;
	}

	/**
	 * The number of scheduled messages in this queue.
	 */
	@SuppressWarnings("unchecked")
	public JMSQueue scheduledCount(Long value) {
		this.scheduledCount = value;
		return (JMSQueue) this;
	}

	/**
	 * The queue selector.
	 */
	@ModelNodeBinding(detypedName = "selector")
	public String selector() {
		return this.selector;
	}

	/**
	 * The queue selector.
	 */
	@SuppressWarnings("unchecked")
	public JMSQueue selector(String value) {
		this.selector = value;
		return (JMSQueue) this;
	}

	/**
	 * Whether the queue is temporary.
	 */
	@ModelNodeBinding(detypedName = "temporary")
	public Boolean temporary() {
		return this.temporary;
	}

	/**
	 * Whether the queue is temporary.
	 */
	@SuppressWarnings("unchecked")
	public JMSQueue temporary(Boolean value) {
		this.temporary = value;
		return (JMSQueue) this;
	}
}