package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.math.BigDecimal;
/**
 * Defines a connection factory.
 */
@ResourceType("legacy-connection-factory")
public class LegacyConnectionFactory<T extends LegacyConnectionFactory> {

	private String key;
	private Boolean autoGroup;
	private Boolean blockOnAcknowledge;
	private Boolean blockOnDurableSend;
	private Boolean blockOnNonDurableSend;
	private Boolean cacheLargeMessageClient;
	private Long callFailoverTimeout;
	private Long callTimeout;
	private Long clientFailureCheckPeriod;
	private String clientId;
	private Boolean compressLargeMessages;
	private Integer confirmationWindowSize;
	private String connectionLoadBalancingPolicyClassName;
	private Long connectionTtl;
	private List<String> connectors = new java.util.ArrayList<>();
	private Integer consumerMaxRate;
	private Integer consumerWindowSize;
	private String discoveryGroup;
	private Integer dupsOkBatchSize;
	private List<String> entries = new java.util.ArrayList<>();
	private String factoryType;
	private Boolean failoverOnInitialConnection;
	private String groupId;
	private Boolean ha;
	private Integer initialConnectAttempts;
	private Integer initialMessagePacketSize;
	private Long maxRetryInterval;
	private Integer minLargeMessageSize;
	private Boolean preAcknowledge;
	private Integer producerMaxRate;
	private Integer producerWindowSize;
	private Integer reconnectAttempts;
	private Long retryInterval;
	private BigDecimal retryIntervalMultiplier;
	private Integer scheduledThreadPoolMaxSize;
	private Integer threadPoolMaxSize;
	private Integer transactionBatchSize;
	private Boolean useGlobalPools;

	public LegacyConnectionFactory(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Whether or not message grouping is automatically used
	 */
	@ModelNodeBinding(detypedName = "auto-group")
	public Boolean autoGroup() {
		return this.autoGroup;
	}

	/**
	 * Whether or not message grouping is automatically used
	 */
	@SuppressWarnings("unchecked")
	public LegacyConnectionFactory autoGroup(Boolean value) {
		this.autoGroup = value;
		return (LegacyConnectionFactory) this;
	}

	/**
	 * True to set block on acknowledge.
	 */
	@ModelNodeBinding(detypedName = "block-on-acknowledge")
	public Boolean blockOnAcknowledge() {
		return this.blockOnAcknowledge;
	}

	/**
	 * True to set block on acknowledge.
	 */
	@SuppressWarnings("unchecked")
	public LegacyConnectionFactory blockOnAcknowledge(Boolean value) {
		this.blockOnAcknowledge = value;
		return (LegacyConnectionFactory) this;
	}

	/**
	 * True to set block on durable send.
	 */
	@ModelNodeBinding(detypedName = "block-on-durable-send")
	public Boolean blockOnDurableSend() {
		return this.blockOnDurableSend;
	}

	/**
	 * True to set block on durable send.
	 */
	@SuppressWarnings("unchecked")
	public LegacyConnectionFactory blockOnDurableSend(Boolean value) {
		this.blockOnDurableSend = value;
		return (LegacyConnectionFactory) this;
	}

	/**
	 * True to set block on non durable send.
	 */
	@ModelNodeBinding(detypedName = "block-on-non-durable-send")
	public Boolean blockOnNonDurableSend() {
		return this.blockOnNonDurableSend;
	}

	/**
	 * True to set block on non durable send.
	 */
	@SuppressWarnings("unchecked")
	public LegacyConnectionFactory blockOnNonDurableSend(Boolean value) {
		this.blockOnNonDurableSend = value;
		return (LegacyConnectionFactory) this;
	}

	/**
	 * True to cache large messages.
	 */
	@ModelNodeBinding(detypedName = "cache-large-message-client")
	public Boolean cacheLargeMessageClient() {
		return this.cacheLargeMessageClient;
	}

	/**
	 * True to cache large messages.
	 */
	@SuppressWarnings("unchecked")
	public LegacyConnectionFactory cacheLargeMessageClient(Boolean value) {
		this.cacheLargeMessageClient = value;
		return (LegacyConnectionFactory) this;
	}

	/**
	 * The timeout to use when fail over is in process (in ms).
	 */
	@ModelNodeBinding(detypedName = "call-failover-timeout")
	public Long callFailoverTimeout() {
		return this.callFailoverTimeout;
	}

	/**
	 * The timeout to use when fail over is in process (in ms).
	 */
	@SuppressWarnings("unchecked")
	public LegacyConnectionFactory callFailoverTimeout(Long value) {
		this.callFailoverTimeout = value;
		return (LegacyConnectionFactory) this;
	}

	/**
	 * The call time out.
	 */
	@ModelNodeBinding(detypedName = "call-timeout")
	public Long callTimeout() {
		return this.callTimeout;
	}

	/**
	 * The call time out.
	 */
	@SuppressWarnings("unchecked")
	public LegacyConnectionFactory callTimeout(Long value) {
		this.callTimeout = value;
		return (LegacyConnectionFactory) this;
	}

	/**
	 * The client failure check period.
	 */
	@ModelNodeBinding(detypedName = "client-failure-check-period")
	public Long clientFailureCheckPeriod() {
		return this.clientFailureCheckPeriod;
	}

	/**
	 * The client failure check period.
	 */
	@SuppressWarnings("unchecked")
	public LegacyConnectionFactory clientFailureCheckPeriod(Long value) {
		this.clientFailureCheckPeriod = value;
		return (LegacyConnectionFactory) this;
	}

	/**
	 * The client id.
	 */
	@ModelNodeBinding(detypedName = "client-id")
	public String clientId() {
		return this.clientId;
	}

	/**
	 * The client id.
	 */
	@SuppressWarnings("unchecked")
	public LegacyConnectionFactory clientId(String value) {
		this.clientId = value;
		return (LegacyConnectionFactory) this;
	}

	/**
	 * Whether large messages should be compressed.
	 */
	@ModelNodeBinding(detypedName = "compress-large-messages")
	public Boolean compressLargeMessages() {
		return this.compressLargeMessages;
	}

	/**
	 * Whether large messages should be compressed.
	 */
	@SuppressWarnings("unchecked")
	public LegacyConnectionFactory compressLargeMessages(Boolean value) {
		this.compressLargeMessages = value;
		return (LegacyConnectionFactory) this;
	}

	/**
	 * The confirmation window size.
	 */
	@ModelNodeBinding(detypedName = "confirmation-window-size")
	public Integer confirmationWindowSize() {
		return this.confirmationWindowSize;
	}

	/**
	 * The confirmation window size.
	 */
	@SuppressWarnings("unchecked")
	public LegacyConnectionFactory confirmationWindowSize(Integer value) {
		this.confirmationWindowSize = value;
		return (LegacyConnectionFactory) this;
	}

	/**
	 * Name of a class implementing a client-side load balancing policy that a client can use to load balance sessions across different nodes in a cluster.
	 */
	@ModelNodeBinding(detypedName = "connection-load-balancing-policy-class-name")
	public String connectionLoadBalancingPolicyClassName() {
		return this.connectionLoadBalancingPolicyClassName;
	}

	/**
	 * Name of a class implementing a client-side load balancing policy that a client can use to load balance sessions across different nodes in a cluster.
	 */
	@SuppressWarnings("unchecked")
	public LegacyConnectionFactory connectionLoadBalancingPolicyClassName(
			String value) {
		this.connectionLoadBalancingPolicyClassName = value;
		return (LegacyConnectionFactory) this;
	}

	/**
	 * The connection ttl.
	 */
	@ModelNodeBinding(detypedName = "connection-ttl")
	public Long connectionTtl() {
		return this.connectionTtl;
	}

	/**
	 * The connection ttl.
	 */
	@SuppressWarnings("unchecked")
	public LegacyConnectionFactory connectionTtl(Long value) {
		this.connectionTtl = value;
		return (LegacyConnectionFactory) this;
	}

	/**
	 * Defines the connectors. These are stored in a map by connector name (with an undefined value). It is possible to pass a list of connector names when writing this attribute.
	 */
	@ModelNodeBinding(detypedName = "connectors")
	public List<String> connectors() {
		return this.connectors;
	}

	/**
	 * Defines the connectors. These are stored in a map by connector name (with an undefined value). It is possible to pass a list of connector names when writing this attribute.
	 */
	@SuppressWarnings("unchecked")
	public LegacyConnectionFactory connectors(List<String> value) {
		this.connectors = value;
		return (LegacyConnectionFactory) this;
	}

	/**
	 * Defines the connectors. These are stored in a map by connector name (with an undefined value). It is possible to pass a list of connector names when writing this attribute.
	 */
	public LegacyConnectionFactory connectorsValue(String value) {
		this.connectors.add(value);
		return (LegacyConnectionFactory) this;
	}

	/**
	 * The consumer max rate.
	 */
	@ModelNodeBinding(detypedName = "consumer-max-rate")
	public Integer consumerMaxRate() {
		return this.consumerMaxRate;
	}

	/**
	 * The consumer max rate.
	 */
	@SuppressWarnings("unchecked")
	public LegacyConnectionFactory consumerMaxRate(Integer value) {
		this.consumerMaxRate = value;
		return (LegacyConnectionFactory) this;
	}

	/**
	 * The consumer window size.
	 */
	@ModelNodeBinding(detypedName = "consumer-window-size")
	public Integer consumerWindowSize() {
		return this.consumerWindowSize;
	}

	/**
	 * The consumer window size.
	 */
	@SuppressWarnings("unchecked")
	public LegacyConnectionFactory consumerWindowSize(Integer value) {
		this.consumerWindowSize = value;
		return (LegacyConnectionFactory) this;
	}

	/**
	 * The discovery group name.
	 */
	@ModelNodeBinding(detypedName = "discovery-group")
	public String discoveryGroup() {
		return this.discoveryGroup;
	}

	/**
	 * The discovery group name.
	 */
	@SuppressWarnings("unchecked")
	public LegacyConnectionFactory discoveryGroup(String value) {
		this.discoveryGroup = value;
		return (LegacyConnectionFactory) this;
	}

	/**
	 * The dups ok batch size.
	 */
	@ModelNodeBinding(detypedName = "dups-ok-batch-size")
	public Integer dupsOkBatchSize() {
		return this.dupsOkBatchSize;
	}

	/**
	 * The dups ok batch size.
	 */
	@SuppressWarnings("unchecked")
	public LegacyConnectionFactory dupsOkBatchSize(Integer value) {
		this.dupsOkBatchSize = value;
		return (LegacyConnectionFactory) this;
	}

	/**
	 * The jndi names the connection factory should be bound to.
	 */
	@ModelNodeBinding(detypedName = "entries")
	public List<String> entries() {
		return this.entries;
	}

	/**
	 * The jndi names the connection factory should be bound to.
	 */
	@SuppressWarnings("unchecked")
	public LegacyConnectionFactory entries(List<String> value) {
		this.entries = value;
		return (LegacyConnectionFactory) this;
	}

	/**
	 * The jndi names the connection factory should be bound to.
	 */
	public LegacyConnectionFactory entriesValue(String value) {
		this.entries.add(value);
		return (LegacyConnectionFactory) this;
	}

	/**
	 * The type of connection factory.
	 */
	@ModelNodeBinding(detypedName = "factory-type")
	public String factoryType() {
		return this.factoryType;
	}

	/**
	 * The type of connection factory.
	 */
	@SuppressWarnings("unchecked")
	public LegacyConnectionFactory factoryType(String value) {
		this.factoryType = value;
		return (LegacyConnectionFactory) this;
	}

	/**
	 * True to fail over on initial connection.
	 */
	@ModelNodeBinding(detypedName = "failover-on-initial-connection")
	public Boolean failoverOnInitialConnection() {
		return this.failoverOnInitialConnection;
	}

	/**
	 * True to fail over on initial connection.
	 */
	@SuppressWarnings("unchecked")
	public LegacyConnectionFactory failoverOnInitialConnection(Boolean value) {
		this.failoverOnInitialConnection = value;
		return (LegacyConnectionFactory) this;
	}

	/**
	 * The group id.
	 */
	@ModelNodeBinding(detypedName = "group-id")
	public String groupId() {
		return this.groupId;
	}

	/**
	 * The group id.
	 */
	@SuppressWarnings("unchecked")
	public LegacyConnectionFactory groupId(String value) {
		this.groupId = value;
		return (LegacyConnectionFactory) this;
	}

	/**
	 * Whether the connection factory supports High Availability.
	 */
	@ModelNodeBinding(detypedName = "ha")
	public Boolean ha() {
		return this.ha;
	}

	/**
	 * Whether the connection factory supports High Availability.
	 */
	@SuppressWarnings("unchecked")
	public LegacyConnectionFactory ha(Boolean value) {
		this.ha = value;
		return (LegacyConnectionFactory) this;
	}

	/**
	 * The number of attempts for the initial connection to the server.
	 */
	@ModelNodeBinding(detypedName = "initial-connect-attempts")
	public Integer initialConnectAttempts() {
		return this.initialConnectAttempts;
	}

	/**
	 * The number of attempts for the initial connection to the server.
	 */
	@SuppressWarnings("unchecked")
	public LegacyConnectionFactory initialConnectAttempts(Integer value) {
		this.initialConnectAttempts = value;
		return (LegacyConnectionFactory) this;
	}

	/**
	 * The initial size of messages created through this factory.
	 */
	@ModelNodeBinding(detypedName = "initial-message-packet-size")
	public Integer initialMessagePacketSize() {
		return this.initialMessagePacketSize;
	}

	/**
	 * The initial size of messages created through this factory.
	 */
	@SuppressWarnings("unchecked")
	public LegacyConnectionFactory initialMessagePacketSize(Integer value) {
		this.initialMessagePacketSize = value;
		return (LegacyConnectionFactory) this;
	}

	/**
	 * The max retry interval.
	 */
	@ModelNodeBinding(detypedName = "max-retry-interval")
	public Long maxRetryInterval() {
		return this.maxRetryInterval;
	}

	/**
	 * The max retry interval.
	 */
	@SuppressWarnings("unchecked")
	public LegacyConnectionFactory maxRetryInterval(Long value) {
		this.maxRetryInterval = value;
		return (LegacyConnectionFactory) this;
	}

	/**
	 * The min large message size.
	 */
	@ModelNodeBinding(detypedName = "min-large-message-size")
	public Integer minLargeMessageSize() {
		return this.minLargeMessageSize;
	}

	/**
	 * The min large message size.
	 */
	@SuppressWarnings("unchecked")
	public LegacyConnectionFactory minLargeMessageSize(Integer value) {
		this.minLargeMessageSize = value;
		return (LegacyConnectionFactory) this;
	}

	/**
	 * True to pre-acknowledge.
	 */
	@ModelNodeBinding(detypedName = "pre-acknowledge")
	public Boolean preAcknowledge() {
		return this.preAcknowledge;
	}

	/**
	 * True to pre-acknowledge.
	 */
	@SuppressWarnings("unchecked")
	public LegacyConnectionFactory preAcknowledge(Boolean value) {
		this.preAcknowledge = value;
		return (LegacyConnectionFactory) this;
	}

	/**
	 * The producer max rate.
	 */
	@ModelNodeBinding(detypedName = "producer-max-rate")
	public Integer producerMaxRate() {
		return this.producerMaxRate;
	}

	/**
	 * The producer max rate.
	 */
	@SuppressWarnings("unchecked")
	public LegacyConnectionFactory producerMaxRate(Integer value) {
		this.producerMaxRate = value;
		return (LegacyConnectionFactory) this;
	}

	/**
	 * The producer window size.
	 */
	@ModelNodeBinding(detypedName = "producer-window-size")
	public Integer producerWindowSize() {
		return this.producerWindowSize;
	}

	/**
	 * The producer window size.
	 */
	@SuppressWarnings("unchecked")
	public LegacyConnectionFactory producerWindowSize(Integer value) {
		this.producerWindowSize = value;
		return (LegacyConnectionFactory) this;
	}

	/**
	 * The reconnect attempts.
	 */
	@ModelNodeBinding(detypedName = "reconnect-attempts")
	public Integer reconnectAttempts() {
		return this.reconnectAttempts;
	}

	/**
	 * The reconnect attempts.
	 */
	@SuppressWarnings("unchecked")
	public LegacyConnectionFactory reconnectAttempts(Integer value) {
		this.reconnectAttempts = value;
		return (LegacyConnectionFactory) this;
	}

	/**
	 * The retry interval.
	 */
	@ModelNodeBinding(detypedName = "retry-interval")
	public Long retryInterval() {
		return this.retryInterval;
	}

	/**
	 * The retry interval.
	 */
	@SuppressWarnings("unchecked")
	public LegacyConnectionFactory retryInterval(Long value) {
		this.retryInterval = value;
		return (LegacyConnectionFactory) this;
	}

	/**
	 * The retry interval multiplier.
	 */
	@ModelNodeBinding(detypedName = "retry-interval-multiplier")
	public BigDecimal retryIntervalMultiplier() {
		return this.retryIntervalMultiplier;
	}

	/**
	 * The retry interval multiplier.
	 */
	@SuppressWarnings("unchecked")
	public LegacyConnectionFactory retryIntervalMultiplier(BigDecimal value) {
		this.retryIntervalMultiplier = value;
		return (LegacyConnectionFactory) this;
	}

	/**
	 * The scheduled thread pool max size.
	 */
	@ModelNodeBinding(detypedName = "scheduled-thread-pool-max-size")
	public Integer scheduledThreadPoolMaxSize() {
		return this.scheduledThreadPoolMaxSize;
	}

	/**
	 * The scheduled thread pool max size.
	 */
	@SuppressWarnings("unchecked")
	public LegacyConnectionFactory scheduledThreadPoolMaxSize(Integer value) {
		this.scheduledThreadPoolMaxSize = value;
		return (LegacyConnectionFactory) this;
	}

	/**
	 * The thread pool max size.
	 */
	@ModelNodeBinding(detypedName = "thread-pool-max-size")
	public Integer threadPoolMaxSize() {
		return this.threadPoolMaxSize;
	}

	/**
	 * The thread pool max size.
	 */
	@SuppressWarnings("unchecked")
	public LegacyConnectionFactory threadPoolMaxSize(Integer value) {
		this.threadPoolMaxSize = value;
		return (LegacyConnectionFactory) this;
	}

	/**
	 * The transaction batch size.
	 */
	@ModelNodeBinding(detypedName = "transaction-batch-size")
	public Integer transactionBatchSize() {
		return this.transactionBatchSize;
	}

	/**
	 * The transaction batch size.
	 */
	@SuppressWarnings("unchecked")
	public LegacyConnectionFactory transactionBatchSize(Integer value) {
		this.transactionBatchSize = value;
		return (LegacyConnectionFactory) this;
	}

	/**
	 * True to use global pools.
	 */
	@ModelNodeBinding(detypedName = "use-global-pools")
	public Boolean useGlobalPools() {
		return this.useGlobalPools;
	}

	/**
	 * True to use global pools.
	 */
	@SuppressWarnings("unchecked")
	public LegacyConnectionFactory useGlobalPools(Boolean value) {
		this.useGlobalPools = value;
		return (LegacyConnectionFactory) this;
	}
}