package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
/**
 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
 */
@ResourceType("ha-policy")
@Implicit
public class LiveOnlyHAPolicy<T extends LiveOnlyHAPolicy> {

	private String key;
	private Boolean scaleDown;
	private String scaleDownClusterName;
	private List<String> scaleDownConnectors = new java.util.ArrayList<>();
	private String scaleDownDiscoveryGroup;
	private String scaleDownGroupName;

	public LiveOnlyHAPolicy() {
		this.key = "live-only";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Configure whether this server send its messages to another live server in the scale-down cluster when it is shutdown cleanly.
	 */
	@ModelNodeBinding(detypedName = "scale-down")
	public Boolean scaleDown() {
		return this.scaleDown;
	}

	/**
	 * Configure whether this server send its messages to another live server in the scale-down cluster when it is shutdown cleanly.
	 */
	@SuppressWarnings("unchecked")
	public LiveOnlyHAPolicy scaleDown(Boolean value) {
		this.scaleDown = value;
		return (LiveOnlyHAPolicy) this;
	}

	/**
	 * Name of the cluster used to scale down.
	 */
	@ModelNodeBinding(detypedName = "scale-down-cluster-name")
	public String scaleDownClusterName() {
		return this.scaleDownClusterName;
	}

	/**
	 * Name of the cluster used to scale down.
	 */
	@SuppressWarnings("unchecked")
	public LiveOnlyHAPolicy scaleDownClusterName(String value) {
		this.scaleDownClusterName = value;
		return (LiveOnlyHAPolicy) this;
	}

	/**
	 * List of connectors used to form the scale-down cluster.
	 */
	@ModelNodeBinding(detypedName = "scale-down-connectors")
	public List<String> scaleDownConnectors() {
		return this.scaleDownConnectors;
	}

	/**
	 * List of connectors used to form the scale-down cluster.
	 */
	@SuppressWarnings("unchecked")
	public LiveOnlyHAPolicy scaleDownConnectors(List<String> value) {
		this.scaleDownConnectors = value;
		return (LiveOnlyHAPolicy) this;
	}

	/**
	 * List of connectors used to form the scale-down cluster.
	 */
	public LiveOnlyHAPolicy scaleDownConnectorsValue(String value) {
		this.scaleDownConnectors.add(value);
		return (LiveOnlyHAPolicy) this;
	}

	/**
	 * Name of the discovery group used to build the scale-down cluster
	 */
	@ModelNodeBinding(detypedName = "scale-down-discovery-group")
	public String scaleDownDiscoveryGroup() {
		return this.scaleDownDiscoveryGroup;
	}

	/**
	 * Name of the discovery group used to build the scale-down cluster
	 */
	@SuppressWarnings("unchecked")
	public LiveOnlyHAPolicy scaleDownDiscoveryGroup(String value) {
		this.scaleDownDiscoveryGroup = value;
		return (LiveOnlyHAPolicy) this;
	}

	/**
	 * Name of the group used to scale down.
	 */
	@ModelNodeBinding(detypedName = "scale-down-group-name")
	public String scaleDownGroupName() {
		return this.scaleDownGroupName;
	}

	/**
	 * Name of the group used to scale down.
	 */
	@SuppressWarnings("unchecked")
	public LiveOnlyHAPolicy scaleDownGroupName(String value) {
		this.scaleDownGroupName = value;
		return (LiveOnlyHAPolicy) this;
	}
}