package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.math.BigDecimal;
/**
 * Defines a managed connection factory.
 */
@ResourceType("pooled-connection-factory")
public class PooledConnectionFactory<T extends PooledConnectionFactory> {

	private String key;
	private Boolean autoGroup;
	private Boolean blockOnAcknowledge;
	private Boolean blockOnDurableSend;
	private Boolean blockOnNonDurableSend;
	private Boolean cacheLargeMessageClient;
	private Long callFailoverTimeout;
	private Long callTimeout;
	private Long clientFailureCheckPeriod;
	private String clientId;
	private Boolean compressLargeMessages;
	private Integer confirmationWindowSize;
	private String connectionLoadBalancingPolicyClassName;
	private Long connectionTtl;
	private List<String> connectors = new java.util.ArrayList<>();
	private Integer consumerMaxRate;
	private Integer consumerWindowSize;
	private String discoveryGroup;
	private Integer dupsOkBatchSize;
	private Boolean enlistmentTrace;
	private List<String> entries = new java.util.ArrayList<>();
	private Boolean failoverOnInitialConnection;
	private String groupId;
	private Boolean ha;
	private Integer initialConnectAttempts;
	private Integer initialMessagePacketSize;
	private String managedConnectionPool;
	private Integer maxPoolSize;
	private Long maxRetryInterval;
	private Integer minLargeMessageSize;
	private Integer minPoolSize;
	private String password;
	private Boolean preAcknowledge;
	private Integer producerMaxRate;
	private Integer producerWindowSize;
	private String protocolManagerFactory;
	private Integer reconnectAttempts;
	private Long retryInterval;
	private BigDecimal retryIntervalMultiplier;
	private Integer scheduledThreadPoolMaxSize;
	private Integer threadPoolMaxSize;
	private String transaction;
	private Integer transactionBatchSize;
	private Boolean useAutoRecovery;
	private Boolean useGlobalPools;
	private String user;
	private String jndiParams;
	private Integer setupAttempts;
	private Long setupInterval;
	private Boolean useJndi;
	private Boolean useLocalTx;

	public PooledConnectionFactory(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The autogroup.
	 */
	@ModelNodeBinding(detypedName = "auto-group")
	public Boolean autoGroup() {
		return this.autoGroup;
	}

	/**
	 * The autogroup.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory autoGroup(Boolean value) {
		this.autoGroup = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * True to set block on acknowledge.
	 */
	@ModelNodeBinding(detypedName = "block-on-acknowledge")
	public Boolean blockOnAcknowledge() {
		return this.blockOnAcknowledge;
	}

	/**
	 * True to set block on acknowledge.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory blockOnAcknowledge(Boolean value) {
		this.blockOnAcknowledge = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * True to set block on durable send.
	 */
	@ModelNodeBinding(detypedName = "block-on-durable-send")
	public Boolean blockOnDurableSend() {
		return this.blockOnDurableSend;
	}

	/**
	 * True to set block on durable send.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory blockOnDurableSend(Boolean value) {
		this.blockOnDurableSend = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * True to set block on non durable send.
	 */
	@ModelNodeBinding(detypedName = "block-on-non-durable-send")
	public Boolean blockOnNonDurableSend() {
		return this.blockOnNonDurableSend;
	}

	/**
	 * True to set block on non durable send.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory blockOnNonDurableSend(Boolean value) {
		this.blockOnNonDurableSend = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * True to cache large messages.
	 */
	@ModelNodeBinding(detypedName = "cache-large-message-client")
	public Boolean cacheLargeMessageClient() {
		return this.cacheLargeMessageClient;
	}

	/**
	 * True to cache large messages.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory cacheLargeMessageClient(Boolean value) {
		this.cacheLargeMessageClient = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * The timeout to use when fail over is in process (in ms).
	 */
	@ModelNodeBinding(detypedName = "call-failover-timeout")
	public Long callFailoverTimeout() {
		return this.callFailoverTimeout;
	}

	/**
	 * The timeout to use when fail over is in process (in ms).
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory callFailoverTimeout(Long value) {
		this.callFailoverTimeout = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * The call time out.
	 */
	@ModelNodeBinding(detypedName = "call-timeout")
	public Long callTimeout() {
		return this.callTimeout;
	}

	/**
	 * The call time out.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory callTimeout(Long value) {
		this.callTimeout = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * The client failure check period.
	 */
	@ModelNodeBinding(detypedName = "client-failure-check-period")
	public Long clientFailureCheckPeriod() {
		return this.clientFailureCheckPeriod;
	}

	/**
	 * The client failure check period.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory clientFailureCheckPeriod(Long value) {
		this.clientFailureCheckPeriod = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * The client id.
	 */
	@ModelNodeBinding(detypedName = "client-id")
	public String clientId() {
		return this.clientId;
	}

	/**
	 * The client id.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory clientId(String value) {
		this.clientId = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * Whether large messages should be compressed.
	 */
	@ModelNodeBinding(detypedName = "compress-large-messages")
	public Boolean compressLargeMessages() {
		return this.compressLargeMessages;
	}

	/**
	 * Whether large messages should be compressed.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory compressLargeMessages(Boolean value) {
		this.compressLargeMessages = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * The confirmation window size.
	 */
	@ModelNodeBinding(detypedName = "confirmation-window-size")
	public Integer confirmationWindowSize() {
		return this.confirmationWindowSize;
	}

	/**
	 * The confirmation window size.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory confirmationWindowSize(Integer value) {
		this.confirmationWindowSize = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * Name of a class implementing a client-side load balancing policy that a client can use to load balance sessions across different nodes in a cluster.
	 */
	@ModelNodeBinding(detypedName = "connection-load-balancing-policy-class-name")
	public String connectionLoadBalancingPolicyClassName() {
		return this.connectionLoadBalancingPolicyClassName;
	}

	/**
	 * Name of a class implementing a client-side load balancing policy that a client can use to load balance sessions across different nodes in a cluster.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory connectionLoadBalancingPolicyClassName(
			String value) {
		this.connectionLoadBalancingPolicyClassName = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * The connection ttl.
	 */
	@ModelNodeBinding(detypedName = "connection-ttl")
	public Long connectionTtl() {
		return this.connectionTtl;
	}

	/**
	 * The connection ttl.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory connectionTtl(Long value) {
		this.connectionTtl = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * Defines the connectors. These are stored in a map by connector name (with an undefined value). It is possible to pass a list of connector names when writing this attribute.
	 */
	@ModelNodeBinding(detypedName = "connectors")
	public List<String> connectors() {
		return this.connectors;
	}

	/**
	 * Defines the connectors. These are stored in a map by connector name (with an undefined value). It is possible to pass a list of connector names when writing this attribute.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory connectors(List<String> value) {
		this.connectors = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * Defines the connectors. These are stored in a map by connector name (with an undefined value). It is possible to pass a list of connector names when writing this attribute.
	 */
	public PooledConnectionFactory connectorsValue(String value) {
		this.connectors.add(value);
		return (PooledConnectionFactory) this;
	}

	/**
	 * The consumer max rate.
	 */
	@ModelNodeBinding(detypedName = "consumer-max-rate")
	public Integer consumerMaxRate() {
		return this.consumerMaxRate;
	}

	/**
	 * The consumer max rate.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory consumerMaxRate(Integer value) {
		this.consumerMaxRate = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * The consumer window size.
	 */
	@ModelNodeBinding(detypedName = "consumer-window-size")
	public Integer consumerWindowSize() {
		return this.consumerWindowSize;
	}

	/**
	 * The consumer window size.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory consumerWindowSize(Integer value) {
		this.consumerWindowSize = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * The discovery group name.
	 */
	@ModelNodeBinding(detypedName = "discovery-group")
	public String discoveryGroup() {
		return this.discoveryGroup;
	}

	/**
	 * The discovery group name.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory discoveryGroup(String value) {
		this.discoveryGroup = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * The dups ok batch size.
	 */
	@ModelNodeBinding(detypedName = "dups-ok-batch-size")
	public Integer dupsOkBatchSize() {
		return this.dupsOkBatchSize;
	}

	/**
	 * The dups ok batch size.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory dupsOkBatchSize(Integer value) {
		this.dupsOkBatchSize = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * Enables IronJacamar to record enlistment traces for this pooled-connection-factory. This attribute is undefined by default and the behaviour is driven by the presence of the ironjacamar.disable_enlistment_trace system property.
	 */
	@ModelNodeBinding(detypedName = "enlistment-trace")
	public Boolean enlistmentTrace() {
		return this.enlistmentTrace;
	}

	/**
	 * Enables IronJacamar to record enlistment traces for this pooled-connection-factory. This attribute is undefined by default and the behaviour is driven by the presence of the ironjacamar.disable_enlistment_trace system property.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory enlistmentTrace(Boolean value) {
		this.enlistmentTrace = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * The jndi names the connection factory should be bound to.
	 */
	@ModelNodeBinding(detypedName = "entries")
	public List<String> entries() {
		return this.entries;
	}

	/**
	 * The jndi names the connection factory should be bound to.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory entries(List<String> value) {
		this.entries = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * The jndi names the connection factory should be bound to.
	 */
	public PooledConnectionFactory entriesValue(String value) {
		this.entries.add(value);
		return (PooledConnectionFactory) this;
	}

	/**
	 * True to fail over on initial connection.
	 */
	@ModelNodeBinding(detypedName = "failover-on-initial-connection")
	public Boolean failoverOnInitialConnection() {
		return this.failoverOnInitialConnection;
	}

	/**
	 * True to fail over on initial connection.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory failoverOnInitialConnection(Boolean value) {
		this.failoverOnInitialConnection = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * The group id.
	 */
	@ModelNodeBinding(detypedName = "group-id")
	public String groupId() {
		return this.groupId;
	}

	/**
	 * The group id.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory groupId(String value) {
		this.groupId = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * Whether the connection factory supports High Availability.
	 */
	@ModelNodeBinding(detypedName = "ha")
	public Boolean ha() {
		return this.ha;
	}

	/**
	 * Whether the connection factory supports High Availability.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory ha(Boolean value) {
		this.ha = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * The number of attempts to connect initially with this factory.
	 */
	@ModelNodeBinding(detypedName = "initial-connect-attempts")
	public Integer initialConnectAttempts() {
		return this.initialConnectAttempts;
	}

	/**
	 * The number of attempts to connect initially with this factory.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory initialConnectAttempts(Integer value) {
		this.initialConnectAttempts = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * The initial size of messages created through this factory.
	 */
	@ModelNodeBinding(detypedName = "initial-message-packet-size")
	public Integer initialMessagePacketSize() {
		return this.initialMessagePacketSize;
	}

	/**
	 * The initial size of messages created through this factory.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory initialMessagePacketSize(Integer value) {
		this.initialMessagePacketSize = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * The class name of the managed connection pool used by this pooled-connection-factory.
	 */
	@ModelNodeBinding(detypedName = "managed-connection-pool")
	public String managedConnectionPool() {
		return this.managedConnectionPool;
	}

	/**
	 * The class name of the managed connection pool used by this pooled-connection-factory.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory managedConnectionPool(String value) {
		this.managedConnectionPool = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * The maximum size for the pool
	 */
	@ModelNodeBinding(detypedName = "max-pool-size")
	public Integer maxPoolSize() {
		return this.maxPoolSize;
	}

	/**
	 * The maximum size for the pool
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory maxPoolSize(Integer value) {
		this.maxPoolSize = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * The max retry interval.
	 */
	@ModelNodeBinding(detypedName = "max-retry-interval")
	public Long maxRetryInterval() {
		return this.maxRetryInterval;
	}

	/**
	 * The max retry interval.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory maxRetryInterval(Long value) {
		this.maxRetryInterval = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * The min large message size.
	 */
	@ModelNodeBinding(detypedName = "min-large-message-size")
	public Integer minLargeMessageSize() {
		return this.minLargeMessageSize;
	}

	/**
	 * The min large message size.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory minLargeMessageSize(Integer value) {
		this.minLargeMessageSize = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * The minimum size for the pool
	 */
	@ModelNodeBinding(detypedName = "min-pool-size")
	public Integer minPoolSize() {
		return this.minPoolSize;
	}

	/**
	 * The minimum size for the pool
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory minPoolSize(Integer value) {
		this.minPoolSize = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * The default password to use with this connection factory. This is only needed when pointing the connection factory to a remote host.
	 */
	@ModelNodeBinding(detypedName = "password")
	public String password() {
		return this.password;
	}

	/**
	 * The default password to use with this connection factory. This is only needed when pointing the connection factory to a remote host.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory password(String value) {
		this.password = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * True to pre-acknowledge.
	 */
	@ModelNodeBinding(detypedName = "pre-acknowledge")
	public Boolean preAcknowledge() {
		return this.preAcknowledge;
	}

	/**
	 * True to pre-acknowledge.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory preAcknowledge(Boolean value) {
		this.preAcknowledge = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * The producer max rate.
	 */
	@ModelNodeBinding(detypedName = "producer-max-rate")
	public Integer producerMaxRate() {
		return this.producerMaxRate;
	}

	/**
	 * The producer max rate.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory producerMaxRate(Integer value) {
		this.producerMaxRate = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * The producer window size.
	 */
	@ModelNodeBinding(detypedName = "producer-window-size")
	public Integer producerWindowSize() {
		return this.producerWindowSize;
	}

	/**
	 * The producer window size.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory producerWindowSize(Integer value) {
		this.producerWindowSize = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * The protocol manager factory used by this pooled connection factory.
	 */
	@ModelNodeBinding(detypedName = "protocol-manager-factory")
	public String protocolManagerFactory() {
		return this.protocolManagerFactory;
	}

	/**
	 * The protocol manager factory used by this pooled connection factory.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory protocolManagerFactory(String value) {
		this.protocolManagerFactory = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * The reconnect attempts. By default, a pooled connection factory will try to reconnect infinitely to the messaging server(s).
	 */
	@ModelNodeBinding(detypedName = "reconnect-attempts")
	public Integer reconnectAttempts() {
		return this.reconnectAttempts;
	}

	/**
	 * The reconnect attempts. By default, a pooled connection factory will try to reconnect infinitely to the messaging server(s).
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory reconnectAttempts(Integer value) {
		this.reconnectAttempts = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * The retry interval.
	 */
	@ModelNodeBinding(detypedName = "retry-interval")
	public Long retryInterval() {
		return this.retryInterval;
	}

	/**
	 * The retry interval.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory retryInterval(Long value) {
		this.retryInterval = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * The retry interval multiplier.
	 */
	@ModelNodeBinding(detypedName = "retry-interval-multiplier")
	public BigDecimal retryIntervalMultiplier() {
		return this.retryIntervalMultiplier;
	}

	/**
	 * The retry interval multiplier.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory retryIntervalMultiplier(BigDecimal value) {
		this.retryIntervalMultiplier = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * The scheduled thread pool max size.
	 */
	@ModelNodeBinding(detypedName = "scheduled-thread-pool-max-size")
	public Integer scheduledThreadPoolMaxSize() {
		return this.scheduledThreadPoolMaxSize;
	}

	/**
	 * The scheduled thread pool max size.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory scheduledThreadPoolMaxSize(Integer value) {
		this.scheduledThreadPoolMaxSize = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * The thread pool max size.
	 */
	@ModelNodeBinding(detypedName = "thread-pool-max-size")
	public Integer threadPoolMaxSize() {
		return this.threadPoolMaxSize;
	}

	/**
	 * The thread pool max size.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory threadPoolMaxSize(Integer value) {
		this.threadPoolMaxSize = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * TODO
	 */
	@ModelNodeBinding(detypedName = "transaction")
	public String transaction() {
		return this.transaction;
	}

	/**
	 * TODO
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory transaction(String value) {
		this.transaction = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * The transaction batch size.
	 */
	@ModelNodeBinding(detypedName = "transaction-batch-size")
	public Integer transactionBatchSize() {
		return this.transactionBatchSize;
	}

	/**
	 * The transaction batch size.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory transactionBatchSize(Integer value) {
		this.transactionBatchSize = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * True to use auto recovery.
	 */
	@ModelNodeBinding(detypedName = "use-auto-recovery")
	public Boolean useAutoRecovery() {
		return this.useAutoRecovery;
	}

	/**
	 * True to use auto recovery.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory useAutoRecovery(Boolean value) {
		this.useAutoRecovery = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * True to use global pools.
	 */
	@ModelNodeBinding(detypedName = "use-global-pools")
	public Boolean useGlobalPools() {
		return this.useGlobalPools;
	}

	/**
	 * True to use global pools.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory useGlobalPools(Boolean value) {
		this.useGlobalPools = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * The default username to use with this connection factory. This is only needed when pointing the connection factory to a remote host.
	 */
	@ModelNodeBinding(detypedName = "user")
	public String user() {
		return this.user;
	}

	/**
	 * The default username to use with this connection factory. This is only needed when pointing the connection factory to a remote host.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory user(String value) {
		this.user = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * The JNDI params to use for locating the destination for incoming connections.
	 */
	@ModelNodeBinding(detypedName = "jndi-params")
	public String jndiParams() {
		return this.jndiParams;
	}

	/**
	 * The JNDI params to use for locating the destination for incoming connections.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory jndiParams(String value) {
		this.jndiParams = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * The number of times to set up an MDB endpoint
	 */
	@ModelNodeBinding(detypedName = "setup-attempts")
	public Integer setupAttempts() {
		return this.setupAttempts;
	}

	/**
	 * The number of times to set up an MDB endpoint
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory setupAttempts(Integer value) {
		this.setupAttempts = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * The interval between attempts at setting up an MDB endpoint.
	 */
	@ModelNodeBinding(detypedName = "setup-interval")
	public Long setupInterval() {
		return this.setupInterval;
	}

	/**
	 * The interval between attempts at setting up an MDB endpoint.
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory setupInterval(Long value) {
		this.setupInterval = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * Use JNDI to locate the destination for incoming connections
	 */
	@ModelNodeBinding(detypedName = "use-jndi")
	public Boolean useJndi() {
		return this.useJndi;
	}

	/**
	 * Use JNDI to locate the destination for incoming connections
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory useJndi(Boolean value) {
		this.useJndi = value;
		return (PooledConnectionFactory) this;
	}

	/**
	 * Use a local transaction for incoming sessions
	 */
	@ModelNodeBinding(detypedName = "use-local-tx")
	public Boolean useLocalTx() {
		return this.useLocalTx;
	}

	/**
	 * Use a local transaction for incoming sessions
	 */
	@SuppressWarnings("unchecked")
	public PooledConnectionFactory useLocalTx(Boolean value) {
		this.useLocalTx = value;
		return (PooledConnectionFactory) this;
	}
}